/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zznk;
import com.aspose.words.internal.zzx3;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzrR;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzrR zzXnt;

    BorderCollection(zzrR parent) {
        this.zzXnt = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzx3.zzZhv(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzI4().equals(brColl.zzI4()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzXnt.getPossibleBorderKeys().zzXsO(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzXnt.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzXnt, borderKey);
            this.zzXnt.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzXnt.getPossibleBorderKeys().zzZmo().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzXnt.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzXnt.getPossibleBorderKeys().zzZmo().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXJy(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzXnt.getPossibleBorderKeys().zzZmo().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXJy(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzI4().zzWui();
    }

    public final void setColor(Color value) throws Exception {
        this.zzZNE(zznk.zzVQb(value));
    }

    private zznk zzI4() throws Exception {
        return this.get(0).zzI4();
    }

    private void zzZNE(zznk zznk2) throws Exception {
        Iterator iterator = this.zzXnt.getPossibleBorderKeys().zzZmo().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXJy(n)) continue;
            this.getByBorderType(n).zzZNE(zznk2);
        }
    }

    final boolean zzUy(int n) {
        return this.zzXnt.getPossibleBorderKeys().zzZ1C(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzXnt.getPossibleBorderKeys().zzZmo().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXJy(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzXnt.getPossibleBorderKeys().zzZmo().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXJy(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzXsO(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzXJy(int n) {
        return n != 6 && n != 7;
    }

    static final class zzXsO
    implements Iterator<Border> {
        private BorderCollection zzWe7;
        private int zzYaK;

        zzXsO(BorderCollection borderCollection) {
            this.zzWe7 = borderCollection;
            this.zzYaK = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzYaK >= this.zzWe7.getCount() - 1) {
                return false;
            }
            ++this.zzYaK;
            return true;
        }

        private Border zzc8() {
            try {
                return this.zzWe7.get(this.zzYaK);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzc8();
        }
    }
}

