/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzI7;
import com.aspose.words.internal.zzW5V;
import com.aspose.words.internal.zzWgE;
import com.aspose.words.internal.zzWlA;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.internal.zzXJy;
import com.aspose.words.internal.zzXN8;
import com.aspose.words.internal.zzXdc;
import com.aspose.words.internal.zzY3Q;
import com.aspose.words.internal.zzYQF;
import com.aspose.words.internal.zzYUJ;
import com.aspose.words.internal.zzYaB;
import com.aspose.words.internal.zzZAF;
import com.aspose.words.internal.zzZCo;
import com.aspose.words.internal.zzeN;
import com.aspose.words.internal.zzmY;
import com.aspose.words.internal.zzx3;
import com.aspose.words.internal.zzyk;
import com.aspose.words.zz0Z;
import com.aspose.words.zz3n;
import com.aspose.words.zzMF;
import com.aspose.words.zzVUH;
import com.aspose.words.zzVXs;
import com.aspose.words.zzW2j;
import com.aspose.words.zzW6;
import com.aspose.words.zzWOe;
import com.aspose.words.zzWQ7;
import com.aspose.words.zzWR5;
import com.aspose.words.zzWXX;
import com.aspose.words.zzWYF;
import com.aspose.words.zzWgZ;
import com.aspose.words.zzWiY;
import com.aspose.words.zzXFz;
import com.aspose.words.zzXPv;
import com.aspose.words.zzXT9;
import com.aspose.words.zzXUb;
import com.aspose.words.zzXVJ;
import com.aspose.words.zzXet;
import com.aspose.words.zzXmh;
import com.aspose.words.zzXoS;
import com.aspose.words.zzXxr;
import com.aspose.words.zzXz7;
import com.aspose.words.zzY3t;
import com.aspose.words.zzYBZ;
import com.aspose.words.zzYUs;
import com.aspose.words.zzYXI;
import com.aspose.words.zzYhB;
import com.aspose.words.zzYke;
import com.aspose.words.zzYqt;
import com.aspose.words.zzYxq;
import com.aspose.words.zzZNl;
import com.aspose.words.zzZYy;
import com.aspose.words.zzZbz;
import com.aspose.words.zzZtm;
import com.aspose.words.zzZyE;
import com.aspose.words.zza4;
import com.aspose.words.zzc8;
import com.aspose.words.zzcr;
import com.aspose.words.zzif;
import com.aspose.words.zznM;
import com.aspose.words.zzq5;
import com.aspose.words.zztn;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzVUH,
zzWYF,
zzXUb,
zztn {
    private Document zzXei;
    private Node zzYe2;
    private Node zzVSI;
    private zzZyE zzZeE;
    private Font zzYnH;
    private zzmY<zzZyE> zzWIT;
    private zzmY<zzYxq> zzYx1;
    private zzmY<zzXsO> zzXEB;
    private zzXxr zzYOa = zzXxr.zzWA7();
    private zzZYy zzd6 = new zzZYy();
    private zzYxq zzYcd;
    private RowFormat zzXUI;
    private CellFormat zzVXj;
    private ParagraphFormat zzYab;
    private zzmY<zz0Z> zzZTt;
    private int zzYEC = 0;
    private int zzXkR = -1;
    private int zzWIl;
    private boolean zzWM7;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzZyM(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzZyM(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzZyM(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXsO(documentBuilder.getCurrentSection(), zzif.zzYRz(headerFooterType), 0, 0);
    }

    private void zzZyM(int n, int n2, int n3, int n4) {
        this.zzXei.ensureMinimum();
        Section section = (Section)this.zzXei.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXsO(section, 1, n3, n4);
    }

    private void zzXsO(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzif.zzZ7Q(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzXei, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzXei));
            }
        }
        this.zzXsO(story, n2, n3);
    }

    private void zzXsO(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXsO((CompositeNode)paragraph2, n3);
    }

    final void zzXsO(Paragraph paragraph, int n) {
        this.zzXsO((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zz4l().zzX9g() ? zzWQ7.zzW4B(this.zzXei, fieldName) : zzWQ7.zzZtT(this.zz4l(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXsO(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXsO(field, isAfter, false);
    }

    private boolean zzXsO(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZbz zzZbz2 = field.getFormat().zzYm();
        Inline inline = zzZbz2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXsO(inline.zzXUK(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zza4.zzXsO(this.zzXei, bookmarkName) : zza4.zzVQb(this.zzXei, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzXVB() == 6) {
            this.zzXsO(node.zzZKi(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYhB.zzZrz(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXsO((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXsO(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzVQb(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzXsO(structuredDocumentTag);
            return;
        }
        this.zzWRw(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzXfN(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXsO((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzXVB() == 6) {
            this.zzYqt(node);
        } else {
            Node node2 = node;
            if (zzYhB.zzX3y(node2.getNodeType())) {
                Paragraph paragraph = zzYhB.zzZrz(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYqt(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzXVB() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYqt(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzWIl = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzZ5d();
            return;
        }
        if (!this.zzWVF()) {
            this.zzZ5d();
        }
    }

    private void zzXsO(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzWVF() {
        Node node = this.zz4l();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zz4l().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXsO(((StructuredDocumentTag)documentBuilder.zz4l().getParentNode()).zzYT4(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zz4l(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXsO(inline.zzXUK(), true);
            return true;
        }
        return false;
    }

    private void zzZ5d() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXsO(documentBuilder.getCurrentParagraph().zzY8v(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzXfN(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzYXQ() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz4l().zzYWX(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzXDa();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXsO((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzW0U(text, false);
    }

    public void writeln(String text) {
        this.zzW0U(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zz4l() != null && this.zz4l().zzXVB() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zz4l().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzX9A();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzXPv zzXPv2 = new zzXPv(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzXei, this.zzYk6(), this.zzYNP());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().zzVTs(paragraph);
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzVQb(this.zz4l(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzXPv2.dispose();
        }
        if (this.getDocument().zzWej()) {
            zzYhB.zzWRw((zzYXI)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzXQ3());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzWaa() {
        zzZyE zzZyE2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzX9A();
        Node node = this.zz4l();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzY1P(false);
        } else {
            run2 = run = (Run)node.zzZ08(21);
        }
        if (run2 == null && zzx3.zzZhv(node, paragraph.zzXPX())) {
            run = paragraph.zzXPX();
        }
        if (run != null) {
            cloneable = run.zzXUK();
            zzZyE2 = (zzZyE)((zzYBZ)cloneable).zzX6P();
        } else {
            cloneable = paragraph.zzY8v();
            zzZyE2 = (zzZyE)((zzYBZ)cloneable).zzX6P();
        }
        zzZyE zzZyE3 = zzZyE2;
        Paragraph paragraph2 = new Paragraph(this.zzXei, this.zzYk6(), zzZyE3);
        paragraph.zzYR4(paragraph2);
        zzXPv zzXPv2 = new zzXPv(this.zzXei);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzVQb(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzXPv2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzYUs.zzW4B(this);
    }

    public void insertBreak(int breakType) {
        this.zzYbq(breakType, true);
    }

    final void zzYbq(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzx3(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zz3L(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzYwp())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzx3(bl)) {
                        this.zz3L(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzx3(bl)) {
                        this.zzmc(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzx3(bl)) {
                        this.zzmc(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzx3(bl)) {
                        this.zzmc(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzx3(bl)) {
                        this.zzmc(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzx3(bl)) {
                        this.zzmc(4);
                    }
                    return;
                }
                case 8: {
                    this.zz3L(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzXN8.zzWS9(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzXdc.zzVQb("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzX9A();
        return zzYhB.zzXsO(fieldType, updateField, this.zzYNP(), this.zzVV9(), this.zzYni(), this.zzYni() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzX9A();
        return zzYhB.zzXsO(fieldCode, this.zzYNP(), this.zzVV9(), this.zzYni(), this.zzYni() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzX9A();
        return zzYhB.zzXsO(fieldCode, fieldValue, this.zzYNP(), this.zzVV9(), this.zzYni(), this.zzYni() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzx3.zzVQb((Object)displayText, "displayText");
        zzx3.zzVQb((Object)urlOrBookmark, "hrefOrBookmark");
        zz3n zz3n2 = this.zzVQb(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        Object object = this;
        zz3n2.zzWRw(((DocumentBuilder)object).zzXEa(88, true));
        object = zz3n2;
        return zzYhB.zzXsO((zz3n)object);
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzZdf(70);
        if (zzXN8.zzWS9(name)) {
            this.startBookmark(name);
        }
        this.zzXrk(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zz9B(70);
        String string = zzXN8.zzWS9(fieldValue) ? fieldValue : FormField.zzVYe;
        Run run = new Run(this.zzXei, string, this.zzYNP());
        this.insertNode(run);
        Node node = this.zzXEa(70, true);
        if (zzXN8.zzWS9(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzWJj(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXsO((CompositeNode)((Paragraph)node.zzZKi()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzZdf(71);
        if (zzXN8.zzWS9(name)) {
            this.startBookmark(name);
        }
        this.zzXrk(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzXEa(71, false);
        if (zzXN8.zzWS9(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzWJj(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzZdf(83);
        if (zzXN8.zzWS9(name)) {
            this.startBookmark(name);
        }
        this.zzXrk(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzXEa(83, false);
        if (zzXN8.zzWS9(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzWJj(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzXei, footnoteType, !zzXN8.zzWS9(referenceMark), referenceMark, this.zzYNP());
        Style style = this.getDocument().getStyles().zzZra(zzYhB.zzXzR(footnoteType));
        footnote.zzXUK().set(50, style.zzZVK());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzXei);
        Style style2 = this.getDocument().getStyles().zzZra(zzYhB.zzXG6(footnoteType));
        paragraph.zzE3().set(1000, style2.zzZVK());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzXei, '\u0002', new zzZyE()) : new Run(this.zzXei, footnote.getReferenceMark(), new zzZyE());
        inline.zzXUK().set(50, style.zzZVK());
        paragraph.appendChild(inline);
        if (zzXN8.zzWS9(footnoteText)) {
            Node node = this.zz4l();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYqt(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzYBL(zzWgE zzWgE2) throws Exception {
        return this.zzXsO(zzWgE2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzYBL(zzWgE.zzVQb(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXsO(zzWgE zzWgE2, double d, double d2) throws Exception {
        return this.zzXsO(zzWgE2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXsO(zzWgE.zzVQb(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzyk zzyk2 = new zzyk();){
            zzeN.zzXsO(image, zzyk2);
            Shape shape = this.zzXsO(zzyk2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzx3.zzWRw(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzWlA.zz5e(fileName);
        try {
            Shape shape = this.zzXsO((zzWgE)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzWgE)object).close();
            }
        }
    }

    private Shape zzXsO(zzWgE zzWgE2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzWgE2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzx3.zzZtT(zzWgE2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXsO(zzWgE.zzVQb(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXsO(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzXsO(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzYQF.zzYjY(object)) {
            object4 = new zzeN((byte[])object);
            bl2 = true;
            ((zzZCo)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzXei.getCompatibilityOptions().getMswVersion() > 12 || this.zzXei.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzXei, 0);
            object3 = new zzXet();
            ((zzWiY)object3).zzXsO(zzcr.zzVP9("rect"));
            ((zzXet)object3).zzXsO(new zzXz7());
            ((zzXet)object3).zzYHb().zzYf3().zzWRw(this.zzXei);
            object2 = new zzXmh();
            ((zzY3t)object2).zzVQb(new zzXFz(this.zzXei.zzYir(), ""));
            ((zzY3t)object2).zzXsO(new zzq5());
            ((zzWOe)object3).zzXsO((zzY3t)object2);
            shape.setShapeType(75);
            shape.zzXr0((zzWOe)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzXei, 75);
        }
        if (zzYQF.zzYXR(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzXsO((byte[])object, new zzWR5(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzWR5(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzYQF.zzXEC((byte[])object2));
                this.zzXsO((zzXet)shape.zzZsJ(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXet)shape.zzZsJ()).zzYHb().zzYf3().zzWzc((byte[])object);
            object3 = zzYQF.zzYyc(object);
            object4 = new zzWR5(((zzXJy)object3).getWidthPoints(), ((zzXJy)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzVQb(this.zzYNP());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzYQF.zzZRr(object)) {
            d5 = DocumentBuilder.zzXsO(shape, object);
        }
        shape.zzXsO(d3, d4, (zzWR5)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzXsO(Shape shape, byte[] byArray) throws Exception {
        int n = zzYQF.zzXyA(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYhB.zzZA7(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYhB.zzWX(n);
        return d;
    }

    private void zzXsO(zzXet zzXet2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXet2.zzYHb().zzYf3().getExtensions();
        try (zzyk zzyk2 = new zzyk(byArray);){
            object = zzYhB.zzXsO(zzyk2, this.zzXei);
            ((zzW6)object).zzW1I(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzW6)object).zzZci();
            byArray2 = ((zzW6)object).zzY1I(true);
        }
        zzXet2.zzYHb().zzYf3().setExtensions(new zzI7<zzWgZ>());
        object = zzWgZ.zzXsO(byArray2, this.zzXei);
        zzXet2.zzYHb().zzYf3().getExtensions().zzWRw(((zzWgZ)object).getUri(), (zzWgZ)object);
    }

    private Shape zzXsO(zzWgE zzWgE2, String string, boolean bl, zzWgE zzWgE3) throws Exception {
        zzMF zzMF2 = zzMF.zzYL1(string);
        Shape shape = this.zzXsO(zzWgE3, bl, zzMF2, null);
        zzc8 zzc82 = zzYke.zzXsO(zzWgE2, string, bl);
        return DocumentBuilder.zzXsO(null, false, shape, zzMF2.zzYiv, zzc82);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXsO(zzWgE.zzVQb(stream), progId, asIcon, zzWgE.zzVQb(presentation));
    }

    private Shape zzXsO(String string, boolean bl, boolean bl2, zzWgE zzWgE2) throws Exception {
        zzMF zzMF2 = zzMF.zz7U(zzY3Q.zzea(string));
        return this.zzXsO(string, bl, bl2, zzWgE2, zzMF2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXsO(fileName, isLinked, asIcon, zzWgE.zzVQb(presentation));
    }

    private Shape zzXsO(String string, String string2, boolean bl, boolean bl2, zzWgE zzWgE2) throws Exception {
        zzMF zzMF2 = zzMF.zzYL1(string2);
        return this.zzXsO(string, bl, bl2, zzWgE2, zzMF2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXsO(fileName, progId, isLinked, asIcon, zzWgE.zzVQb(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzMF zzMF2 = zzMF.zz7U(zzY3Q.zzea(fileName));
        return this.zzXsO(fileName, isLinked, iconFile, iconCaption, zzMF2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzMF zzMF2 = zzMF.zzYL1(progId);
        return this.zzXsO(fileName, isLinked, iconFile, iconCaption, zzMF2);
    }

    private Shape zzVQb(zzWgE zzWgE2, String string, String string2, String string3) throws Exception {
        zzMF zzMF2 = zzMF.zzYL1(string);
        Shape shape = this.zzXsO(string2, string3, zzMF2);
        zzc8 zzc82 = zzYke.zzXsO(zzWgE2, string, true);
        return DocumentBuilder.zzXsO(null, false, shape, zzMF2.zzYiv, zzc82);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzVQb(zzWgE.zzVQb(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXsO(zzZtm zzZtm2, zzWgE zzWgE2) throws Exception {
        Shape shape = this.zzYXR(zzWgE2);
        shape.setShapeType(201);
        shape.zzYX9(4112, zzZtm2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzX9A();
        if (this.zzXyk()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzZDx(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZNl zzZNl2 = zzYhB.zzXsO(html, options, this);
        zzZNl2.zzR6();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzX9A();
        return zzYhB.zzXsO(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzX9A();
        return zzYhB.zzXsO(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzXoS zzXoS2 = new zzXoS();
        return zzXoS2.zzXsO(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWXX(this).zzXsO(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWXX(this).zzXsO(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzXei, 75);
        shape.zzVQb(this.zzYNP());
        shape.zzYBz(true);
        shape.getSignatureLine().zzXsO(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzN9(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zza4(this.zzXei);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzXyk() {
        boolean bl = false;
        if (this.zz4l().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zz4l().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZDx(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzX9A();
        if (this.zzYXQ() == null) {
            this.startTable();
        }
        if (this.zzYXQ().zzXnv() == 1) {
            this.zzYXQ().zzWPR();
        }
        if (this.zzYXQ().zzXnv() == 3) {
            this.zzYXQ().zzWc0();
        }
        return this.zzYXQ().zzGx();
    }

    public Table startTable() {
        this.zzZTt.push(new zz0Z(this));
        return this.zzYXQ().startTable();
    }

    public Table endTable() {
        if (this.zzYXQ() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzYXQ().endTable();
        this.zzZTt.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzYXQ() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzYXQ().endRow();
        if (this.zzYnH != null && this.zzYnH.getHidden()) {
            row.zzI6().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXei, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXei, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYDq();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXei, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzXg();
        bookmarkStart.zz53(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYDq();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzXg();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXei, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzZCo(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzXei);
        this.zzXkR = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzXkR == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXei, this.zzXkR);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXei, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzx3.zzVQb((Object)importFormatOptions, "ImportFormatOptions");
        this.zzX9A();
        return zzW2j.zzXsO(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzx3.zzVQb((Object)importFormatOptions, "ImportFormatOptions");
        this.zzX9A();
        importFormatOptions.zzVU8(true);
        Node node = zzW2j.zzXsO(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzVU8(false);
        return node;
    }

    public Document getDocument() {
        return this.zzXei;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzXei) {
            return;
        }
        this.zzXei = value;
        this.zzYqt(null);
        this.zzZeE = new zzZyE();
        this.zzWIT = null;
        this.zzYx1 = null;
        this.zzYnH = null;
        this.zzZTt = new zzmY();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzYnH == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYnH = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzYnH;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzYab == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYab = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzYab;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzXUI == null) {
            this.zzXUI = new RowFormat(this);
        }
        return this.zzXUI;
    }

    public CellFormat getCellFormat() {
        if (this.zzVXj == null) {
            this.zzVXj = new CellFormat(this);
        }
        return this.zzVXj;
    }

    final void zzOV(Node node) {
        this.getCurrentParagraph().zzYR4(node);
    }

    public void pushFont() {
        zzZyE zzZyE2;
        if (this.getCurrentParagraph() != null) {
            zzZyE zzZyE3 = this.getCurrentParagraph().zzY8v();
            zzZyE2 = (zzZyE)zzZyE3.zzX6P();
        } else {
            zzZyE2 = this.zzYNP();
        }
        zzZyE zzZyE4 = zzZyE2;
        this.zzVOE().push(new zzXsO(this.zzYNP(), zzZyE4));
    }

    public void popFont() {
        zzmY<zzXsO> zzmY2 = this.zzVOE();
        if (zzmY2.size() > 0) {
            zzXsO zzXsO2 = (zzXsO)this.zzVOE().pop();
            this.zzXsO(zzXsO2.zzXUK(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXoC(zzXsO2.zz9E());
            }
        }
    }

    final void zzXU() {
        this.zzXdb().push(this.zzYNP());
    }

    final void zzWFJ() {
        zzmY<zzZyE> zzmY2 = this.zzXdb();
        if (zzmY2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXsO((zzZyE)documentBuilder.zzXdb().pop(), false);
        }
    }

    final void zzYcZ() {
        this.zzVVn().push(this.zzYk6());
    }

    final void zzWCh() {
        zzmY<zzYxq> zzmY2 = this.zzVVn();
        if (zzmY2.size() > 0) {
            zzYxq zzYxq2 = (zzYxq)this.zzVVn().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXsO(zzYxq2);
            }
        }
    }

    private zz3n zzVQb(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzZdf(88);
        zzXT9 zzXT92 = new zzXT9();
        zzXT92.setTarget(string2);
        zzXT92.setScreenTip(string3);
        if (bl) {
            zzXT92.setSubAddress(string);
        } else {
            zzXT92.setAddress(zzZAF.zzWIe(string));
            zzXT92.setSubAddress(zzZAF.zzZlX(string));
        }
        this.zzXrk(zzXT92.zzwj());
        FieldSeparator fieldSeparator = this.zz9B(88);
        return new zz3n(fieldStart, fieldSeparator, null);
    }

    final zz3n zzXa(String string, String string2, String string3) {
        boolean bl = zzZAF.zzZVw(string);
        String string4 = bl ? zzZAF.zzZlX(string) : string;
        return this.zzVQb(string4, bl, string2, string3);
    }

    final zz3n zzXsO(zzXT9 zzXT92) {
        FieldStart fieldStart = this.zzZdf(88);
        this.zzXrk(zzXT92.zzwj());
        FieldSeparator fieldSeparator = this.zz9B(88);
        return new zz3n(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzu3() {
        return this.zzXEa(88, true);
    }

    final zzZyE zzYNP() {
        zzZyE zzZyE2 = this.zzZeE;
        return (zzZyE)zzZyE2.zzX6P();
    }

    final zzYxq zzYk6() {
        zzYxq zzYxq2 = this.zzE3();
        return (zzYxq)zzYxq2.zzX6P();
    }

    final zzXxr zzVY6() {
        zzXxr zzXxr2 = this.zzI6();
        return (zzXxr)zzXxr2.zzX6P();
    }

    final zzZYy zzXUJ() {
        zzZYy zzZYy2 = this.zzZsh();
        return (zzZYy)zzZYy2.zzX6P();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz4l(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz4l().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzWM7 && this.zz4l().getNodeType() == 28;
    }

    private void zzW0U(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zz4l()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzif.zzVt(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzna(string2.substring(n4, n4 + n2));
                }
                switch (this.zzYEC) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zz3L(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzna(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzX9A();
        if (this.zzYXQ() != null && this.zzYXQ().zzXnv() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zz4l().zzYR4(node);
    }

    final void zzXfC(int n) {
        this.zzx3(true);
        this.zzmc(n);
    }

    private void zzmc(int n) {
        this.insertParagraph();
        zzXPv zzXPv2 = new zzXPv(this.getDocument());
        try {
            zznM zznM2 = this.getCurrentSection().zzZtR();
            zznM zznM3 = (zznM)zznM2.zzX6P();
            Section section = new Section(this.zzXei, zznM3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzXei));
            this.zzXei.insertAfter(section, this.getCurrentSection());
            section.getBody().zzVQb(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzXPv2.dispose();
        }
    }

    final FieldStart zzZdf(int n) {
        this.zzX9A();
        return zzYhB.zzXsO(n, this.zzYNP(), this.zzVV9(), this.zzYni(), this.zzYni() == null);
    }

    final Run zzXrk(String string) {
        return zzYhB.zzVQb(string, this.zzYNP(), this.zzVV9(), this.zzYni(), this.zzYni() == null);
    }

    final FieldEnd zzXEa(int n, boolean bl) {
        return zzYhB.zzVQb(n, bl, this.zzYNP(), this.zzVV9(), this.zzYni(), this.zzYni() == null);
    }

    final FieldSeparator zz9B(int n) {
        return zzYhB.zzVQb(n, this.zzYNP(), this.zzVV9(), this.zzYni(), this.zzYni() == null);
    }

    private FormField zzWJj(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzXei, new zzXVJ(), this.zzYNP());
        CompositeNode compositeNode = node == null ? this.zzVV9() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzx3(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzYXQ() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzXfN(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzna(String string) {
        if (this.zzZhs(string)) {
            zzYUJ zzYUJ2 = new zzYUJ(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzW5V zzW5V2 : zzYUJ2.zzYPj(this.getParagraphFormat().getBidi())) {
                zzYqt zzYqt2 = zzYqt.zzXZD(zzW5V2.zzZiP());
                zzZyE zzZyE2 = this.zzYNP();
                zzZyE2.zzYGx(265, zzYqt2);
                if (zzW5V2.zzZld()) {
                    zzZyE2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzXei, zzW5V2.getText(), zzZyE2);
                this.insertNode(run);
            }
            return;
        }
        this.zz3L(string);
    }

    private boolean zzZhs(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYaB.zzZes(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXsO(zzZyE zzZyE2, boolean bl) {
        zzZyE zzZyE3;
        if (bl) {
            zzZyE zzZyE4 = zzZyE2;
            zzZyE3 = (zzZyE)zzZyE4.zzX6P();
        } else {
            zzZyE3 = zzZyE2;
        }
        this.zzZeE = zzZyE3;
    }

    final void zzWRm() {
        this.zzZeE.clear();
    }

    final void zzOH() {
        if (this.zzYDq() != null) {
            zzZYy zzZYy2;
            zzZYy zzZYy3 = zzZYy2 = this.zzYDq().zzZsh();
            this.zzd6 = (zzZYy)zzZYy3.zzX6P();
            zzZYy2.zzVQb(this.zzd6);
        }
    }

    private Shape zzXsO(String string, boolean bl, boolean bl2, zzWgE zzWgE2, zzMF zzMF2) throws Exception {
        if (zzMF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzXsO(zzWgE2, bl2, zzMF2, string);
        zzc8 zzc82 = zzYke.zzXsO(string, bl, bl2, zzMF2);
        return DocumentBuilder.zzXsO(string, bl, shape, zzMF2.zzYiv, zzc82);
    }

    private Shape zzXsO(String string, boolean bl, String string2, String string3, zzMF zzMF2) throws Exception {
        if (zzMF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzY3Q.zzXYb(string);
        }
        Shape shape = string2 != null ? this.zzXyA(string2, string3) : this.zzXsO(null, string3, zzMF2);
        zzc8 zzc82 = zzYke.zzXsO(string, bl, true, zzMF2);
        return DocumentBuilder.zzXsO(string, bl, shape, zzMF2.zzYiv, zzc82);
    }

    private static Shape zzXsO(String string, boolean bl, Shape shape, String string2, zzc8 zzc82) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzVQb(zzc82);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXsO(zzWgE zzWgE2, boolean bl, zzMF zzMF2, String string) throws Exception {
        if (zzMF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzWgE2 != null) {
            return this.zzYXR(zzWgE2);
        }
        if (!bl) {
            return this.zzXvz(zzYke.zzZUK().get("normal"));
        }
        String string2 = string != null ? zzY3Q.zzXYb(string) : zzYke.zzW8j(zzMF2.zzWnY);
        return this.zzXsO(zzMF2, string2);
    }

    private Shape zzXsO(String string, String string2, zzMF zzMF2) throws Exception {
        if (zzMF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzYke.zzW8j(zzMF2.zzWnY);
        }
        if (string != null) {
            return this.zzXyA(string, string2);
        }
        return this.zzXsO(zzMF2, string2);
    }

    private Shape zzXsO(zzMF zzMF2, String string) throws Exception {
        if (zzMF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzYke.zzZWt(zzMF2.zzWnY);
        zzWlL zzWlL2 = new zzWlL(byArray, null, string, this.getDocument().zzXD4());
        return this.zzXvz(zzWlL2.zz2C());
    }

    private Shape zzXyA(String string, String string2) throws Exception {
        zzWlL zzWlL2 = new zzWlL(string, string2, this.getDocument().zzXD4());
        return this.zzXvz(zzWlL2.zz2C());
    }

    private Shape zzYXR(zzWgE zzWgE2) throws Exception {
        byte[] byArray = zzx3.zzZtT(zzWgE2);
        return this.zzXvz(byArray);
    }

    private Shape zzXvz(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzXei, 1);
        shape.setShapeType(75);
        shape.zzVQb(this.zzYNP());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzN9(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXsO(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzVQb(compositeNode, n);
            return;
        }
        this.zzWRw(compositeNode, n);
    }

    private void zzVQb(CompositeNode compositeNode, int n) {
        zzVXs zzVXs2 = zzVXs.zzYvf(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzVXs2.zzXsO(null, true, true, true, false, true);
            node = zzVXs2.getNode();
            if (zzVXs2.zzWBR() && (!node.isComposite() || node.zzXVB() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzXw5().length() : node.getTextLength();
            if (!zzVXs2.zzWBR() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzVXs2.zzWBR() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzXsO((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzXsO(null, node);
            this.zzWIl = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXsO(StructuredDocumentTag structuredDocumentTag) {
        this.zzYqt(structuredDocumentTag);
        this.zzWM7 = true;
        this.zzWIl = 0;
        zzZyE zzZyE2 = structuredDocumentTag.zzYT4();
        switch (structuredDocumentTag.zzXVB()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzWb6(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzZyE2 = ((Inline)node).zzXUK();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzZyE2 = paragraph.zzY8v();
                break;
            }
            default: {
                return;
            }
        }
        this.zzXsO(zzZyE2, true);
    }

    private void zzWRw(CompositeNode compositeNode, int n) {
        zzVXs zzVXs2 = zzVXs.zzJc(compositeNode);
        while (zzVXs2.getNode() != compositeNode || !zzVXs2.zzWBR()) {
            int n2;
            Node node = zzVXs2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzXw5().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzXsO(null, node);
                this.zzWIl = n;
                return;
            }
            while (zzVXs2.zzXsO(null, false, true, true, false, true) && zzVXs2.zzWBR() && zzVXs2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzX9A() {
        int n = this.zzWIl;
        if (n == 0) {
            return;
        }
        this.zzWIl = 0;
        Run run = zzx3.zzXsO((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzYA5(n);
        }
    }

    private Run zz3L(String string) {
        Run run = new Run(this.zzXei, string, this.zzYNP());
        this.insertNode(run);
        return run;
    }

    final boolean zzZz3() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZ9o() {
        return this.zzYEC;
    }

    final void zzY1f(int n) {
        this.zzYEC = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zz4l();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz4l();
        }
        return (Paragraph)this.zz4l().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zz4l();
        }
        return (StructuredDocumentTag)this.zz4l().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zz4l().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zz0Z zzYXQ() {
        return zzx3.zzXsO(this.zzZTt);
    }

    private Cell zzYDq() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzYH6();
    }

    private CompositeNode zzVV9() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zz4l();
        }
        return this.zz4l().getParentNode();
    }

    private Node zzYni() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zz4l();
    }

    private zzmY<zzZyE> zzXdb() {
        if (this.zzWIT == null) {
            this.zzWIT = new zzmY();
        }
        return this.zzWIT;
    }

    private zzmY<zzYxq> zzVVn() {
        if (this.zzYx1 == null) {
            this.zzYx1 = new zzmY();
        }
        return this.zzYx1;
    }

    private zzmY<zzXsO> zzVOE() {
        if (this.zzXEB == null) {
            this.zzXEB = new zzmY();
        }
        return this.zzXEB;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZeE.zzWNb(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzZeE.zzXlp(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZPL(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZPL(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZeE.zzYGx(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZ6O()) {
            this.getCurrentParagraph().zzY8v().zzYGx(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZeE.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZeE.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZ6O()) {
            this.getCurrentParagraph().zzY8v().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzE3().zzWNb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzE3().zzXlp(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzYPG(key, 0);
        }
        return this.getDocument().getStyles().zzZIJ().zzW1i(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzE3().zzYGx(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzE3().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzE3().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzI6().zzWNb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzI6().zzW1i(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzI6().zzXtn(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzI6().zzYGx(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzI6().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzI6().clear();
        zzXxr.zzWA7().zzVQb(this.zzI6());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZsh().zzWNb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZsh().zzW1i(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZsh().zzXtn(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzx3.zzXsO(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzYDq() != null ? this.zzYDq().getCellFormat() : this.getCellFormat();
            border.zzXsO(cellFormat);
        }
        this.zzZsh().zzYGx(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZsh().clear();
    }

    private Node zz4l() {
        Node node = this.zzYe2 != null && this.zzYe2.getParentNode() == null ? this.zzVSI : this.zzYe2;
        if (node != null && node.zzXVB() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzWM7 = this.zzWM7 && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzYqt(Node node) {
        this.zzYe2 = node;
        if (this.zzYe2 != null) {
            this.zzVSI = this.zzYe2.getParentNode();
        }
        this.zzWM7 = false;
    }

    private zzYxq zzE3() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzE3();
        }
        if (this.zzYcd == null) {
            this.zzYcd = new zzYxq();
        }
        return this.zzYcd;
    }

    private zzXxr zzI6() {
        if (this.zzYXQ() != null && this.zzYXQ().zzXnv() == 1) {
            return this.zzYOa;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzI6();
        }
        return this.zzYOa;
    }

    private zzZYy zzZsh() {
        if (this.zzYXQ() != null && this.zzYXQ().zzXnv() != 3) {
            return this.zzd6;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzYH6().zzZsh();
        }
        return this.zzd6;
    }

    static final class zzXsO {
        private zzZyE zzZeE;
        private zzZyE zzZmb;

        public zzXsO(zzZyE zzZyE2, zzZyE zzZyE3) {
            this.zzZeE = zzZyE2;
            this.zzZmb = zzZyE3;
        }

        public final zzZyE zzXUK() {
            return this.zzZeE;
        }

        public final zzZyE zz9E() {
            return this.zzZmb;
        }
    }
}

