/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWgE;
import com.aspose.words.internal.zzXN8;
import com.aspose.words.internal.zzXX1;
import com.aspose.words.internal.zzXm7;
import com.aspose.words.internal.zzZTn;
import com.aspose.words.internal.zzx3;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYsz;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWrZ = new HashMap();
    private static HashMap<Integer, Integer> zzbY = new HashMap();
    private static HashMap<Integer, Integer> zzZRy = new HashMap();
    private static HashMap<Integer, Integer> zzWI1 = new HashMap();
    private static HashMap<Integer, Integer> zzWEO = new HashMap();
    private static HashMap<Integer, Integer> zzYQB = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzx3.zzWRw(fileName, "fileName");
        try (zzZTn zzZTn2 = zzx3.zzN9(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzXFi(zzZTn2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzXFi(zzXX1.zzXsO(stream));
    }

    static FileFormatInfo zzXFi(zzWgE zzWgE2) throws Exception {
        if (zzWgE2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzYsz zzYsz2 = new zzYsz();
            zzWgE zzWgE3 = zzWgE2;
            zzYsz zzYsz3 = zzYsz2;
            return zzYsz2.zzVQb(zzWgE3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzWRw(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzvo(zzXm7.zzYX9(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzZwQ(zzXm7.zzYX9(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzXN8.zzWS9(string = zzXm7.zzYfT(FileFormatUtil.zzYkY(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzvo(FileFormatUtil.zzuz(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzZwQ(FileFormatUtil.zzYkY(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXm7.zzYfT(FileFormatUtil.zzuz(saveFormat));
        if (zzXN8.zzWS9(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzZwQ(zzXm7.zzX5i(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXm7.zzYfT(FileFormatUtil.zzX01(imageType));
    }

    static Exception zzWRw(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzYXZ(int n) {
        return zzXm7.toString(FileFormatUtil.zzuz(n));
    }

    static int zzZwQ(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzx3.zzXsO(zzWEO, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzZ8l(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzx3.zzXsO(zzYQB, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzVV8(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYkY(int n) {
        return zzx3.zzXsO(zzWrZ, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzuz(int n) {
        return zzx3.zzXsO(zzbY, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzX01(int n) {
        return zzx3.zzXsO(zzZRy, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzvo(int n) {
        return zzx3.zzXsO(zzWI1, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXa(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzx3.zzVQb(zzWEO, Integer.valueOf(n), Integer.valueOf(n2));
            zzx3.zzVQb(zzbY, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWI1.containsKey(n)) {
                zzx3.zzVQb(zzWI1, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzx3.zzVQb(zzWrZ, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzx3.zzVQb(zzYQB, Integer.valueOf(n), Integer.valueOf(n4));
            zzx3.zzVQb(zzZRy, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXa(13, 10, 10, 1);
        FileFormatUtil.zzXa(13, 0, 0, 1);
        FileFormatUtil.zzXa(14, 11, 11, 1);
        FileFormatUtil.zzXa(15, 20, 20, 1);
        FileFormatUtil.zzXa(15, 0, 254, 1);
        FileFormatUtil.zzXa(16, 21, 21, 1);
        FileFormatUtil.zzXa(17, 22, 22, 1);
        FileFormatUtil.zzXa(18, 23, 23, 1);
        FileFormatUtil.zzXa(20, 24, 24, 1);
        FileFormatUtil.zzXa(21, 25, 25, 1);
        FileFormatUtil.zzXa(22, 26, 26, 1);
        FileFormatUtil.zzXa(23, 27, 27, 1);
        FileFormatUtil.zzXa(26, 30, 30, 1);
        FileFormatUtil.zzXa(19, 31, 31, 1);
        FileFormatUtil.zzXa(27, 50, 50, 1);
        FileFormatUtil.zzXa(28, 45, 255, 1);
        FileFormatUtil.zzXa(29, 51, 51, 1);
        FileFormatUtil.zzXa(30, 54, 52, 1);
        FileFormatUtil.zzXa(31, 0, 53, 1);
        FileFormatUtil.zzXa(33, 53, 54, 1);
        FileFormatUtil.zzXa(24, 60, 60, 1);
        FileFormatUtil.zzXa(25, 61, 61, 1);
        FileFormatUtil.zzXa(36, 40, 64, 1);
        FileFormatUtil.zzXa(43, 47, 255, 1);
        FileFormatUtil.zzXa(44, 48, 255, 1);
        FileFormatUtil.zzXa(37, 41, 255, 1);
        FileFormatUtil.zzXa(38, 46, 255, 1);
        FileFormatUtil.zzXa(40, 42, 255, 1);
        FileFormatUtil.zzXa(39, 44, 255, 1);
        FileFormatUtil.zzXa(32, 52, 55, 1);
        FileFormatUtil.zzXa(34, 70, 62, 1);
        FileFormatUtil.zzXa(35, 73, 63, 1);
        FileFormatUtil.zzXa(41, 71, 255, 1);
        FileFormatUtil.zzXa(8, 100, 255, 1);
        FileFormatUtil.zzXa(9, 105, 255, 10);
        FileFormatUtil.zzXa(6, 101, 255, 6);
        FileFormatUtil.zzXa(7, 102, 255, 7);
        FileFormatUtil.zzXa(5, 104, 255, 5);
        FileFormatUtil.zzXa(4, 0, 255, 4);
        FileFormatUtil.zzXa(3, 0, 255, 3);
        FileFormatUtil.zzXa(42, 72, 255, 1);
        FileFormatUtil.zzXa(2, 103, 255, 2);
        FileFormatUtil.zzXa(10, 106, 255, 8);
        FileFormatUtil.zzXa(48, 80, 255, 1);
        FileFormatUtil.zzXa(11, 107, 255, 9);
    }
}

