/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXdc;
import com.aspose.words.internal.zzmY;
import com.aspose.words.internal.zzx3;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVXs;
import com.aspose.words.zzW7e;
import com.aspose.words.zzWYq;
import com.aspose.words.zzWyb;
import com.aspose.words.zzYhB;
import com.aspose.words.zzg8;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzXoO;
    private Node zzYrE;
    private Node zzcX;
    private int zzZGZ;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzWRw(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzXoO == null) {
            return null;
        }
        if (this.zzXoO.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzXoO;
    }

    final CompositeNode zzZKi() {
        if (zzYhB.zzYX9(this.getParentNode())) {
            return this.getParentNode().zzZKi();
        }
        return this.getParentNode();
    }

    final CompositeNode zzZJL() {
        if (zzYhB.zzYX9(this.getParentNode()) || zzYhB.zzYrj(this.getParentNode())) {
            return this.getParentNode().zzZJL();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzXoO != null) {
            return this.zzXoO.getDocument();
        }
        return null;
    }

    final Document zzjO() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzW7j() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzYDF();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzcX;
    }

    final Node zzXEx() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzYhB.zzX3y((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzWX8() {
        Node node = zzYhB.zzYGx(this.getPreviousSibling(), false);
        if (node == null && zzYhB.zzYX9(this.getParentNode())) {
            node = this.getParentNode().zzWX8();
        }
        return node;
    }

    final Node zzoe() {
        Node node = zzYhB.zzZyM(this.getNextSibling(), false);
        if (node == null && zzYhB.zzYX9(this.getParentNode())) {
            node = this.getParentNode().zzoe();
        }
        return node;
    }

    final CompositeNode zzsc() {
        Node node = this;
        while ((node = node.zzWX8()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzXDa() {
        Node node = this;
        while ((node = node.zzoe()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYrE;
    }

    final Node zzXrq() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzYhB.zzX3y((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZnI() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXnN() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXuw() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYhB.zzWb0(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWSO() {
        return this.zzYrE;
    }

    final void zzZlJ(Node node) {
        this.zzYrE = node;
    }

    final Node zzWH8() {
        return this.zzcX;
    }

    final void zzW4T(Node node) {
        this.zzcX = node;
    }

    final Node zzXDS() {
        Node node = this;
        if (node.zzYrE != null) {
            node = this;
            return node.zzYrE;
        }
        return this.getParentNode();
    }

    final int zzXVB() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYhB.zzWKd(this);
        boolean bl2 = zzYhB.zza4(this);
        boolean bl3 = zzYhB.zzVr(this);
        boolean bl4 = zzYhB.zzYYD(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzXVB() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzXVB() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXsO(isCloneChildren, new zzXsO(this));
    }

    Node zzXsO(boolean bl, zzW7e zzW7e2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzXoO != null) {
            node.zzXoO = this.getDocument().zzmE();
        }
        node.zzYrE = null;
        node.zzcX = null;
        if (zzW7e2 != null) {
            zzW7e2.zzZ28(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzXN5(StringBuilder stringBuilder) {
        zzx3.zzVQb(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zzWyb zzCb() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zzWyb zzWyb2 = zzx3.zzXsO((Object)compositeNode, zzWyb.class);
            if (zzWyb2 == null) continue;
            return zzWyb2;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzJQ(Node node) {
        this.zzXoO = node != null ? node : this.getDocument().zzmE();
    }

    final void zzWRw(DocumentBase documentBase) {
        this.zzXoO = documentBase != null ? documentBase.zzmE() : null;
    }

    final boolean zzYWX(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzX3a() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzYFi(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZ08(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzZhv(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzXN5(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzYlX(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zzVTs(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final void zzWJj(Node node, Node node2) {
        this.getParentNode().zzVQb(node, node2, this);
    }

    final Node zzYR4(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    final void zzYqt(Node node, Node node2) {
        this.getParentNode().zzXsO(node, node2, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzWYq zzWYq2 = zzYhB.zzWEE(saveFormat);
        return zzWYq2.zzYj3(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzWYq zzWYq2 = zzYhB.zzVQb(saveOptions);
        return zzWYq2.zzYj3(this);
    }

    final Node zzZpB(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYhB.zzW67(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzVXs zzZEi() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzVXs.zzJc(node);
        }
        return zzVXs.zzYvf(this.getParentNode());
    }

    final zzVXs zzXuD() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzVXs.zzYvf(node);
        }
        return zzVXs.zzJc(this.getParentNode());
    }

    final boolean zzQF(Node node) {
        return Node.zzYBZ(this, node);
    }

    final boolean zzX9g() {
        return this.getAncestor(1) == null;
    }

    static Node zzW0U(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzmY<Node> zzmY2 = Node.zzYEc(node);
        zzmY<Node> zzmY3 = Node.zzYEc(node2);
        return Node.zzXsO(zzmY2, zzmY3);
    }

    static boolean zzYBZ(Node node, Node node2) {
        zzmY<Node> zzmY2;
        if (node == null || node2 == null) {
            return false;
        }
        zzmY<Node> zzmY3 = Node.zzYEc(node);
        Node node3 = Node.zzXsO(zzmY3, zzmY2 = Node.zzYEc(node2));
        if (node3 == null) {
            return false;
        }
        zzmY<Node> zzmY4 = zzmY3;
        if (zzmY4.size() == 0 || (zzmY4 = zzmY2).size() == 0) {
            zzmY4 = zzmY2;
            boolean bl = zzmY4.size() > 0;
            return bl;
        }
        Object e = zzmY3.peek();
        Object e2 = zzmY2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzmY<Node> zzYEc(Node node) {
        zzmY<Node> zzmY2 = new zzmY<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzmY2.push(node2);
        }
        return zzmY2;
    }

    private static Node zzXsO(zzmY<Node> zzmY2, zzmY<Node> zzmY3) {
        Node node = null;
        while (zzmY2.peek() == zzmY3.peek()) {
            node = (Node)zzmY2.pop();
            zzmY3.pop();
            zzmY<Node> zzmY4 = zzmY2;
            if (zzmY4.size() != 0 && (zzmY4 = zzmY3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzZGZ;
    }

    public void setCustomNodeId(int value) {
        this.zzZGZ = value;
    }

    private String zzYmo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzx3.zzXsO(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzXdc.zzXt0(stringBuilder.toString());
    }

    public String toString() {
        return zzXdc.zzXt0(zzXdc.zzVQb("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzYmo()));
    }

    public void dd() {
    }

    final Node zzVPh(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzWb0(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYLu(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzWb0(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzWb0(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzXsO
    implements zzW7e {
        private Node zzW8U;
        private HashMap<Integer, Integer> zzWtl;

        zzXsO(Node node) {
            this.zzW8U = node;
        }

        @Override
        public final void zzZ28(Node node, Node node2) {
            if (node == this.zzW8U) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzg8 zzg82 = (zzg8)((Object)node2);
            if (this.zzWtl == null) {
                this.zzWtl = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzx3.zzXsO(this.zzWtl, Integer.valueOf(zzg82.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzXlt();
                zzx3.zzVQb(this.zzWtl, Integer.valueOf(zzg82.getIdInternal()), Integer.valueOf(n));
            }
            zzg82.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzx3.zzXsO(this.zzWtl, Integer.valueOf(zzg82.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzg82.setParentIdInternal(n2);
            }
        }
    }
}

