/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXdc;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzVUs = new ArrayList();
    private final Map<String, DataColumn> zzXNN = new HashMap<String, DataColumn>();
    private DataTable zzZS6;

    DataColumnCollection(DataTable table) {
        this.zzZS6 = table;
    }

    public void add(DataColumn column) {
        if (zzXdc.zzVU8(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzYTr(column.getColumnName());
        if (this.zzXNN.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzZ28(this.zzZS6);
        column.setOrdinal(this.zzVUs.size());
        this.zzVUs.add(column);
        this.zzXNN.put(string, column);
        this.zzZS6.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZS6);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZS6);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzXdc.zzVU8(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzYTr(columnName);
        DataColumn dataColumn = this.zzXNN.get(string);
        if (dataColumn != null) {
            int n = this.zzVUs.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzVUs.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzVUs.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzVUs.remove(n);
            this.zzXNN.remove(DataColumnCollection.zzYTr(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZS6.getRows()) {
                dataRow.remove(n);
            }
            this.zzZS6.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzVUs.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzVUs.iterator();
    }

    public void clear() {
        this.zzXNN.clear();
        this.zzVUs.clear();
    }

    final DataColumn[] zzlx() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzVUs);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXsO(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzVUs.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzVUs.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzYTr(string);
            String string3 = DataColumnCollection.zzYTr(dataColumn.getColumnName());
            this.zzXNN.remove(string3);
            this.zzXNN.put(string2, dataColumn);
            return;
        }
    }

    private static String zzYTr(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

