/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.provider.AbstractProvider;
import org.apache.maven.surefire.api.provider.CommandChainReader;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.report.ConsoleOutputCapture;
import org.apache.maven.surefire.api.report.ReporterException;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.Stoppable;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.api.util.ScannerFilter;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.apache.maven.surefire.api.util.internal.ConcurrencyUtils;
import org.apache.maven.surefire.junitplatform.CancellationTokenAdapter;
import org.apache.maven.surefire.junitplatform.LauncherAdapter;
import org.apache.maven.surefire.junitplatform.LauncherSessionAdapter;
import org.apache.maven.surefire.junitplatform.LauncherSessionFactory;
import org.apache.maven.surefire.junitplatform.RunListenerAdapter;
import org.apache.maven.surefire.junitplatform.TestMethodFilter;
import org.apache.maven.surefire.junitplatform.TestPlanScannerFilter;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

public class JUnitPlatformProvider
extends AbstractProvider {
    static final String CONFIGURATION_PARAMETERS = "configurationParameters";
    private final ProviderParameters parameters;
    private final LauncherSessionFactory launcherSessionFactory;
    private final Filter<?>[] filters;
    private final Map<String, String> configurationParameters;
    private final CommandChainReader commandsReader;

    public JUnitPlatformProvider(ProviderParameters parameters) {
        this(parameters, LauncherSessionFactory.DEFAULT);
    }

    JUnitPlatformProvider(ProviderParameters parameters, LauncherSessionFactory launcherSessionFactory) {
        this.parameters = parameters;
        this.launcherSessionFactory = launcherSessionFactory;
        this.filters = this.newFilters();
        this.configurationParameters = this.newConfigurationParameters();
        this.commandsReader = parameters.isInsideFork() ? parameters.getCommandReader() : null;
    }

    public Iterable<Class<?>> getSuites() {
        try (LauncherSessionAdapter launcherSession = this.launcherSessionFactory.openSession();){
            TestsToRun testsToRun = this.scanClasspath(launcherSession.getLauncher());
            return testsToRun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        RunResult runResult;
        block12: {
            ReporterFactory reporterFactory = this.parameters.getReporterFactory();
            TestReportListener runListener = reporterFactory.createTestReportListener();
            CancellationTokenAdapter cancellationToken = CancellationTokenAdapter.tryCreate();
            Stoppable stoppable = this.prepareFailFastSupport(cancellationToken, runListener);
            RunListenerAdapter adapter = new RunListenerAdapter((TestReportListener<TestOutputReportEntry>)runListener, stoppable);
            adapter.setRunMode(RunMode.NORMAL_RUN);
            ConsoleOutputCapture.startCapture((TestOutputReceiver)adapter);
            JUnitPlatformProvider.setupJunitLogger();
            try (LauncherSessionAdapter launcherSession = this.launcherSessionFactory.openSession(cancellationToken);){
                LauncherAdapter launcher = launcherSession.getLauncher();
                if (forkTestSet instanceof TestsToRun) {
                    this.invokeAllTests(launcher, (TestsToRun)forkTestSet, adapter);
                    break block12;
                }
                if (forkTestSet instanceof Class) {
                    this.invokeAllTests(launcher, TestsToRun.fromClass((Class)((Class)forkTestSet)), adapter);
                    break block12;
                }
                if (forkTestSet == null) {
                    this.invokeAllTests(launcher, this.scanClasspath(launcher), adapter);
                    break block12;
                }
                throw new IllegalArgumentException("Unexpected value of forkTestSet: " + forkTestSet);
            }
            finally {
                runResult = reporterFactory.close();
            }
        }
        return runResult;
    }

    private static void setupJunitLogger() {
        Logger logger = Logger.getLogger("org.junit");
        if (logger.getLevel() == null) {
            logger.setLevel(Level.WARNING);
        }
    }

    private TestsToRun scanClasspath(LauncherAdapter launcher) {
        TestPlanScannerFilter filter = new TestPlanScannerFilter(launcher, this.filters);
        ScanResult scanResult = this.parameters.getScanResult();
        TestsToRun scannedClasses = scanResult.applyFilter((ScannerFilter)filter, this.parameters.getTestClassLoader());
        return this.parameters.getRunOrderCalculator().orderTestClasses(scannedClasses);
    }

    private void invokeAllTests(LauncherAdapter launcher, TestsToRun testsToRun, RunListenerAdapter adapter) throws TestSetFailedException {
        if (this.commandsReader != null) {
            this.commandsReader.addShutdownListener(__ -> testsToRun.markTestSetFinished());
            this.commandsReader.awaitStarted();
        }
        this.execute(launcher, testsToRun, adapter);
        int count = this.parameters.getTestRequest().getRerunFailingTestsCount();
        if (count > 0 && adapter.hasFailingTests()) {
            adapter.setRunMode(RunMode.RERUN_TEST_AFTER_FAILURE);
            for (int i = 0; i < count; ++i) {
                LauncherDiscoveryRequest discoveryRequest = this.buildLauncherDiscoveryRequestForRerunFailures(adapter);
                adapter.reset();
                launcher.executeWithoutCancellationToken(discoveryRequest, adapter);
                if (!adapter.hasFailingTests()) break;
            }
        }
    }

    private void execute(LauncherAdapter launcher, TestsToRun testsToRun, RunListenerAdapter adapter) {
        TestExecutionListener[] testExecutionListeners = new TestExecutionListener[]{adapter};
        if (testsToRun.allowEagerReading()) {
            ArrayList selectors = new ArrayList();
            testsToRun.iterator().forEachRemaining(c -> selectors.add(DiscoverySelectors.selectClass((String)c.getName())));
            LauncherDiscoveryRequestBuilder builder = this.newRequest().selectors(selectors);
            launcher.execute(builder.build(), testExecutionListeners);
        } else {
            testsToRun.iterator().forEachRemaining(c -> {
                LauncherDiscoveryRequestBuilder builder = this.newRequest().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)c.getName())});
                launcher.execute(builder.build(), testExecutionListeners);
            });
        }
    }

    private LauncherDiscoveryRequest buildLauncherDiscoveryRequestForRerunFailures(RunListenerAdapter adapter) {
        LauncherDiscoveryRequestBuilder builder = this.newRequest();
        for (TestIdentifier identifier : new LinkedHashSet<TestIdentifier>(adapter.getFailures().keySet())) {
            builder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectUniqueId((String)identifier.getUniqueId())});
        }
        return builder.build();
    }

    private LauncherDiscoveryRequestBuilder newRequest() {
        return LauncherDiscoveryRequestBuilder.request().filters(this.filters).configurationParameters(this.configurationParameters);
    }

    private Filter<?>[] newFilters() {
        ArrayList filters = new ArrayList();
        this.getPropertiesList("groups").map(TagFilter::includeTags).ifPresent(filters::add);
        this.getPropertiesList("excludegroups").map(TagFilter::excludeTags).ifPresent(filters::add);
        Optional.of(TestListResolver.optionallyWildcardFilter((TestListResolver)this.parameters.getTestRequest().getTestListResolver())).filter(f -> !f.isEmpty()).filter(f -> !f.isWildcard()).map(TestMethodFilter::new).ifPresent(filters::add);
        this.getPropertiesList("includejunit5engines").map(EngineFilter::includeEngines).ifPresent(filters::add);
        this.getPropertiesList("excludejunit5engines").map(EngineFilter::excludeEngines).ifPresent(filters::add);
        return filters.toArray(new Filter[0]);
    }

    Filter<?>[] getFilters() {
        return this.filters;
    }

    private Map<String, String> newConfigurationParameters() {
        String content = (String)this.parameters.getProviderProperties().get(CONFIGURATION_PARAMETERS);
        if (content == null) {
            return Collections.emptyMap();
        }
        StringReader reader = new StringReader(content);
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Properties props = new Properties();
            props.load(reader);
            props.stringPropertyNames().forEach(key -> result.put((String)key, props.getProperty((String)key)));
            HashMap<String, String> hashMap = result;
            reader.close();
            return hashMap;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading configurationParameters", e);
            }
        }
    }

    Map<String, String> getConfigurationParameters() {
        return this.configurationParameters;
    }

    private Optional<List<String>> getPropertiesList(String key) {
        String property = (String)this.parameters.getProviderProperties().get(key);
        return StringUtils.isBlank((String)property) ? Optional.empty() : Optional.of(Arrays.stream(property.split("[,]+")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList()));
    }

    private Stoppable prepareFailFastSupport(CancellationTokenAdapter cancellationToken, TestReportListener<?> runListener) {
        int skipAfterFailureCount = this.parameters.getSkipAfterFailureCount();
        if (skipAfterFailureCount > 0) {
            AtomicBoolean loggedFailedAttempt = new AtomicBoolean(false);
            Runnable cancellation = () -> JUnitPlatformProvider.cancelExecution(cancellationToken, (ConsoleLogger)runListener, loggedFailedAttempt, skipAfterFailureCount);
            if (this.commandsReader != null) {
                this.commandsReader.addSkipNextTestsListener(__ -> cancellation.run());
            }
            AtomicInteger remainingFailures = new AtomicInteger(skipAfterFailureCount);
            return () -> {
                ConcurrencyUtils.runIfZeroCountDown((Runnable)cancellation, (AtomicInteger)remainingFailures);
                runListener.testExecutionSkippedByUser();
            };
        }
        return Stoppable.NOOP;
    }

    private static void cancelExecution(CancellationTokenAdapter cancellationToken, ConsoleLogger consoleLogger, AtomicBoolean loggedFailedAttempt, int skipAfterFailureCount) {
        if (cancellationToken != null) {
            cancellationToken.cancel();
        } else if (loggedFailedAttempt.compareAndSet(false, true)) {
            consoleLogger.warning(String.format("An attempt was made to cancel the current test run due to the configured skipAfterFailureCount of %d. ", skipAfterFailureCount) + "However, the version of JUnit Platform on the runtime classpath does not support cancellation. Please update to 6.0.0 or later!");
        }
    }
}

