/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.multipart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.multipart.MultipartConfig;
import org.smartboot.http.common.multipart.Part;
import org.smartboot.http.common.utils.StringUtils;

public class PartImpl
implements Part {
    private String name;
    private String fileName;
    private InputStream inputStream;
    private OutputStream diskOutputStream;
    private int formSize;
    private File diskFile;
    private final List<HeaderValue> headers = new ArrayList<HeaderValue>(8);
    private int headerSize = 0;
    private String headerTemp;
    private String contentType;
    private final MultipartConfig multipartConfig;
    private ByteArrayOutputStream thresholdBuffer;
    private boolean thresholdPushed;

    public PartImpl(MultipartConfig multipartConfig) {
        this.multipartConfig = multipartConfig;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.fileName == null && this.inputStream == null) {
            throw new IllegalStateException();
        }
        if (this.inputStream == null && this.thresholdBuffer != null) {
            this.inputStream = new ByteArrayInputStream(this.thresholdBuffer.toByteArray());
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        this.inputStream = Files.newInputStream(this.diskFile.toPath(), new OpenOption[0]);
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader(HeaderNameEnum.CONTENT_TYPE.getName());
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSubmittedFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        if (this.diskFile != null) {
            return this.diskFile.length();
        }
        return this.formSize;
    }

    @Override
    public void delete() throws IOException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
        }
        if (this.diskFile != null) {
            try {
                this.diskFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.diskFile = null;
        }
    }

    @Override
    public String getHeader(String name) {
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(name)) continue;
            return headerValue.getValue();
        }
        return null;
    }

    public void setHeadValue(String value) {
        this.setHeader(this.headerTemp, value);
    }

    public void setHeaderTemp(String headerTemp) {
        this.headerTemp = headerTemp;
    }

    public void setHeader(String headerName, String value) {
        if (this.headerSize < this.headers.size()) {
            HeaderValue headerValue = this.headers.get(this.headerSize);
            headerValue.setName(headerName);
            headerValue.setValue(value);
        } else {
            this.headers.add(new HeaderValue(headerName, value));
        }
        ++this.headerSize;
    }

    @Override
    public Collection<String> getHeaders(String name) {
        ArrayList<String> value = new ArrayList<String>(4);
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(name)) continue;
            value.add(headerValue.getValue());
        }
        return value;
    }

    @Override
    public Collection<String> getHeaderNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            nameSet.add(this.headers.get(i).getName());
        }
        return nameSet;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setFormSize(int formSize) {
        this.formSize = formSize;
    }

    public void write(byte[] bytes) throws IOException {
        if (this.multipartConfig.getFileSizeThreshold() > 0) {
            if (this.thresholdBuffer == null) {
                this.thresholdBuffer = new ByteArrayOutputStream();
            }
            if (this.thresholdBuffer.size() < this.multipartConfig.getFileSizeThreshold()) {
                this.thresholdBuffer.write(bytes);
            } else {
                if (!this.thresholdPushed) {
                    this.getDiskOutputStream().write(this.thresholdBuffer.toByteArray());
                    this.thresholdPushed = true;
                }
                this.getDiskOutputStream().write(bytes);
            }
        } else {
            this.getDiskOutputStream().write(bytes);
        }
    }

    public void flush() throws IOException {
        if (this.diskOutputStream != null) {
            this.diskOutputStream.flush();
            this.thresholdBuffer = null;
        }
        if (this.thresholdBuffer != null) {
            this.formSize = this.thresholdBuffer.size();
        }
    }

    public void close() throws IOException {
        if (this.diskOutputStream != null) {
            this.diskOutputStream.close();
            this.thresholdBuffer = null;
        }
    }

    private OutputStream getDiskOutputStream() throws IOException {
        if (this.fileName == null) {
            throw new IllegalStateException();
        }
        if (this.diskOutputStream == null) {
            this.diskFile = this.getFile();
            this.diskFile.deleteOnExit();
            this.diskOutputStream = Files.newOutputStream(this.diskFile.toPath(), new OpenOption[0]);
        }
        return this.diskOutputStream;
    }

    private File getFile() throws IOException {
        File location;
        if (StringUtils.isNotBlank(this.multipartConfig.getLocation()) && (location = new File(this.multipartConfig.getLocation())).isDirectory()) {
            return new File(location, this.hashCode() + "_" + this.fileName);
        }
        return File.createTempFile("smart-http_" + this.hashCode() + "_", this.fileName);
    }
}

