/*******************************************************************************
 * Copyright (c) 2017-2021, org.smartboot. All rights reserved.
 * project name: smart-http
 * file name: WebSocketOutputStream.java
 * Date: 2021-02-07
 * Author: sandao (zhengjunweimail@163.com)
 ******************************************************************************/

package org.smartboot.http.server.impl;

import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.utils.Constant;
import org.smartboot.http.server.HttpServerConfiguration;

import java.io.IOException;

/**
 * @author 三刀
 * @version V1.0 , 2018/2/3
 */
final class WebSocketOutputStream extends AbstractOutputStream {
    private final HttpServerConfiguration configuration;

    public WebSocketOutputStream(WebSocketRequestImpl webSocketRequest, WebSocketResponseImpl response) {
        super(webSocketRequest.request, response);
        this.configuration = request.getConfiguration();
        //ws不支持chunked
        disableChunked();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (configuration.getWsIdleTimeout() > 0 || configuration.getHttpIdleTimeout() > 0) {
            ((Request) request).setLatestIo(System.currentTimeMillis());
        }
    }

    protected void writeHeadPart(boolean hasHeader) throws IOException {
        // HTTP/1.1
        writeString(request.getProtocol().getProtocol());
        writeBuffer.writeByte((byte) ' ');

        // Status
        HttpStatus httpStatus = response.getHttpStatus();
        httpStatus.write(writeBuffer);

        String contentType = response.getContentType();
        if (contentType == null) {
            contentType = HeaderValueEnum.DEFAULT_CONTENT_TYPE.getName();
        }

        writeString(HeaderNameEnum.CONTENT_TYPE.getName());
        writeBuffer.writeByte((byte) ':');
        writeString(contentType);
        writeBuffer.write(Constant.CRLF_BYTES);
        if (!hasHeader) {
            writeBuffer.write(Constant.CRLF_BYTES);
        }
    }

}
