/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import org.smartboot.http.common.codec.websocket.BasicFrameDecoder;
import org.smartboot.http.common.codec.websocket.Decoder;
import org.smartboot.http.common.codec.websocket.WebSocket;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.io.BufferOutputStream;
import org.smartboot.http.common.utils.SHA1;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.http.server.impl.WebSocketResponseImpl;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.util.AttachKey;
import org.smartboot.socket.util.Attachment;

public abstract class WebSocketHandler
implements ServerHandler<WebSocketRequest, WebSocketResponse> {
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final AttachKey<Decoder> FRAME_DECODER_KEY = AttachKey.valueOf((String)"ws_frame_decoder");
    private final Decoder basicFrameDecoder = new BasicFrameDecoder();

    public void willHeaderComplete(WebSocketRequestImpl request, WebSocketResponseImpl response) {
    }

    public final void onHeaderComplete(Request request) throws IOException {
        WebSocketRequestImpl webSocketRequest = request.newWebsocketRequest();
        WebSocketResponseImpl response = webSocketRequest.getResponse();
        this.willHeaderComplete(webSocketRequest, response);
        String key = request.getHeader(HeaderNameEnum.Sec_WebSocket_Key);
        String acceptSeed = key + WEBSOCKET_13_ACCEPT_GUID;
        byte[] sha1 = SHA1.encode((String)acceptSeed);
        String accept = Base64.getEncoder().encodeToString(sha1);
        response.setHttpStatus(HttpStatus.SWITCHING_PROTOCOLS);
        response.setHeader(HeaderNameEnum.UPGRADE.getName(), HeaderValueEnum.WEBSOCKET.getName());
        response.setHeader(HeaderNameEnum.CONNECTION.getName(), HeaderValueEnum.UPGRADE.getName());
        response.setHeader(HeaderNameEnum.Sec_WebSocket_Accept.getName(), accept);
        BufferOutputStream outputStream = response.getOutputStream();
        outputStream.flush();
        Attachment attachment = request.getAttachment();
        if (attachment == null) {
            attachment = new Attachment();
            request.setAttachment(attachment);
        }
        attachment.put(FRAME_DECODER_KEY, (Object)this.basicFrameDecoder);
        request.setAttachment(attachment);
        this.whenHeaderComplete(webSocketRequest, response);
    }

    public void whenHeaderComplete(WebSocketRequestImpl request, WebSocketResponseImpl response) {
    }

    public final void onBodyStream(ByteBuffer byteBuffer, Request request) {
        Attachment attachment = request.getAttachment();
        Decoder decoder = ((Decoder)attachment.get(FRAME_DECODER_KEY)).decode(byteBuffer, (WebSocket)request.newWebsocketRequest());
        if (decoder == WebSocket.PAYLOAD_FINISH) {
            attachment.put(FRAME_DECODER_KEY, (Object)this.basicFrameDecoder);
            try {
                this.handleWebSocketRequest(request.newWebsocketRequest(), request.getAioSession());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            attachment.put(FRAME_DECODER_KEY, (Object)decoder);
        }
    }

    private void handleWebSocketRequest(WebSocketRequestImpl abstractRequest, AioSession session) throws Throwable {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        this.handle(abstractRequest, abstractRequest.getResponse(), future);
        if (future.isDone()) {
            this.finishResponse(abstractRequest);
        } else {
            Thread thread = Thread.currentThread();
            session.awaitRead();
            future.thenRun(() -> {
                try {
                    this.finishResponse(abstractRequest);
                    if (thread != Thread.currentThread()) {
                        session.writeBuffer().flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    abstractRequest.getResponse().close();
                }
                finally {
                    session.signalRead();
                }
            });
        }
    }

    private void finishResponse(WebSocketRequestImpl abstractRequest) throws IOException {
        WebSocketResponseImpl response = abstractRequest.getResponse();
        if (!response.getOutputStream().isClosed()) {
            response.getOutputStream().close();
        }
        abstractRequest.reset();
    }
}

