/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.exts;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.noear.snack.annotation.ONodeAttr;
import org.noear.snack.exception.SnackException;

public class EnumWrap {
    protected final Map<String, Enum> enumMap = new HashMap<String, Enum>();
    protected final Map<String, Enum> enumCustomMap = new HashMap<String, Enum>();
    protected final Enum[] enumOrdinal;
    protected final Class<?> enumClass;
    protected Field enumCustomFiled;

    public Class<?> enumClass() {
        return this.enumClass;
    }

    public EnumWrap(Class<?> enumClass) {
        this.enumClass = enumClass;
        this.enumOrdinal = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < this.enumOrdinal.length; ++i) {
            Enum e = this.enumOrdinal[i];
            if (this.enumMap.containsKey(e.name().toLowerCase())) continue;
            this.enumMap.put(e.name().toLowerCase(), e);
            for (Field field : e.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(ONodeAttr.class)) continue;
                field.setAccessible(true);
                try {
                    Object custom = field.get(e);
                    this.enumCustomFiled = field;
                    this.enumCustomMap.put(enumClass.getName() + "#" + custom, e);
                }
                catch (IllegalAccessException ex) {
                    throw new SnackException(ex);
                }
            }
        }
    }

    public Enum get(int ordinal) {
        return this.enumOrdinal[ordinal];
    }

    public Enum get(String name) {
        return this.enumMap.get(name.toLowerCase());
    }

    public Enum getCustom(String custom) {
        return this.enumCustomMap.get(this.enumClass.getName() + "#" + custom);
    }

    public boolean hasCustom() {
        return this.enumCustomMap.size() > 0;
    }

    public Object getCustomValue(Object o) {
        try {
            if (this.enumCustomFiled == null) {
                return null;
            }
            return this.enumCustomFiled.get(o);
        }
        catch (IllegalAccessException e) {
            throw new SnackException(e);
        }
    }
}

