/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import org.noear.socketd.transport.client.Client;
import org.noear.socketd.transport.client.ClientChannel;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.socketd.transport.client.ClientConfigHandler;
import org.noear.socketd.transport.client.ClientConnector;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.HeartbeatHandler;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.internal.ProcessorDefault;
import org.noear.socketd.transport.core.internal.SessionDefault;

public abstract class ClientBase<T extends ChannelAssistant>
implements Client {
    protected Processor processor = new ProcessorDefault();
    protected HeartbeatHandler heartbeatHandler;
    private final ClientConfig config;
    private final T assistant;

    public ClientBase(ClientConfig clientConfig, T assistant) {
        this.config = clientConfig;
        this.assistant = assistant;
    }

    public T assistant() {
        return this.assistant;
    }

    public HeartbeatHandler heartbeatHandler() {
        return this.heartbeatHandler;
    }

    public long heartbeatInterval() {
        return this.config.getHeartbeatInterval();
    }

    public ClientConfig config() {
        return this.config;
    }

    public Processor processor() {
        return this.processor;
    }

    @Override
    public Client heartbeatHandler(HeartbeatHandler handler) {
        if (handler != null) {
            this.heartbeatHandler = handler;
        }
        return this;
    }

    @Override
    public Client config(ClientConfigHandler consumer) {
        consumer.clientConfig(this.config);
        return this;
    }

    @Override
    public Client process(Processor processor) {
        if (processor != null) {
            this.processor = processor;
        }
        return this;
    }

    @Override
    public Client listen(Listener listener) {
        this.processor.setListener(listener);
        return this;
    }

    @Override
    public Session open() throws Exception {
        ClientConnector connector = this.createConnector();
        ChannelInternal channel0 = connector.connect();
        ClientChannel clientChannel = new ClientChannel(channel0, connector);
        clientChannel.setHandshake(channel0.getHandshake());
        SessionDefault session = new SessionDefault(clientChannel);
        channel0.setSession(session);
        return session;
    }

    protected abstract ClientConnector createConnector();
}

