/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Codec;
import org.noear.socketd.transport.core.CodecByteBuffer;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.FragmentHandler;
import org.noear.socketd.transport.core.IdGenerator;
import org.noear.socketd.transport.core.buffer.BufferReader;
import org.noear.socketd.transport.core.buffer.BufferWriter;
import org.noear.socketd.transport.core.fragment.FragmentHandlerDefault;
import org.noear.socketd.transport.core.identifier.GuidGenerator;
import org.noear.socketd.utils.NamedThreadFactory;

public abstract class ConfigBase<T extends Config>
implements Config {
    private final boolean clientMode;
    protected Charset charset;
    protected Codec<BufferReader, BufferWriter> codec;
    protected IdGenerator idGenerator;
    protected FragmentHandler fragmentHandler;
    protected SSLContext sslContext;
    protected ExecutorService channelExecutor;
    protected int coreThreads;
    protected int maxThreads;
    protected int readBufferSize;
    protected int writeBufferSize;
    protected long idleTimeout;
    protected long requestTimeout;
    protected int maxRequests;
    protected int maxUdpSize;

    public ConfigBase(boolean clientMode) {
        this.clientMode = clientMode;
        this.charset = StandardCharsets.UTF_8;
        this.codec = new CodecByteBuffer(this);
        this.idGenerator = new GuidGenerator();
        this.fragmentHandler = new FragmentHandlerDefault();
        this.coreThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        this.maxThreads = this.coreThreads * 8;
        this.readBufferSize = 512;
        this.writeBufferSize = 512;
        this.idleTimeout = 0L;
        this.requestTimeout = 10000L;
        this.maxRequests = 10;
        this.maxUdpSize = 2048;
    }

    @Override
    public boolean clientMode() {
        return this.clientMode;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    public T charset(Charset charset) {
        this.charset = charset;
        return (T)this;
    }

    @Override
    public Codec<BufferReader, BufferWriter> getCodec() {
        return this.codec;
    }

    public T codec(Codec<BufferReader, BufferWriter> codec) {
        Asserts.assertNull(codec, "codec");
        this.codec = codec;
        return (T)this;
    }

    @Override
    public FragmentHandler getFragmentHandler() {
        return this.fragmentHandler;
    }

    public T fragmentHandler(FragmentHandler fragmentHandler) {
        Asserts.assertNull(fragmentHandler, "fragmentHandler");
        this.fragmentHandler = fragmentHandler;
        return (T)this;
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public T idGenerator(IdGenerator idGenerator) {
        Asserts.assertNull(idGenerator, "idGenerator");
        this.idGenerator = idGenerator;
        return (T)this;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public T sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getChannelExecutor() {
        if (this.channelExecutor == null) {
            ConfigBase configBase = this;
            synchronized (configBase) {
                if (this.channelExecutor == null) {
                    int nThreads = this.clientMode() ? this.coreThreads : this.maxThreads;
                    this.channelExecutor = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Socketd-channelExecutor-"));
                }
            }
        }
        return this.channelExecutor;
    }

    public T channelExecutor(ExecutorService channelExecutor) {
        this.channelExecutor = channelExecutor;
        return (T)this;
    }

    @Override
    public int getCoreThreads() {
        return this.coreThreads;
    }

    public T coreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
        return (T)this;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public T maxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return (T)this;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public T readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return (T)this;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public T writeBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return (T)this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public T idleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return (T)this;
    }

    @Override
    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public T requestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (T)this;
    }

    @Override
    public int getMaxRequests() {
        return this.maxRequests;
    }

    public T maxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
        return (T)this;
    }

    @Override
    public int getMaxUdpSize() {
        return this.maxUdpSize;
    }

    public T maxUdpSize(int maxUdpSize) {
        this.maxUdpSize = maxUdpSize;
        return (T)this;
    }
}

