/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Session;

public abstract class SessionBase
implements Session {
    protected final Channel channel;
    private final String sessionId;
    private Map<String, Object> attrMap;

    public SessionBase(Channel channel) {
        this.channel = channel;
        this.sessionId = this.generateId();
    }

    @Override
    public Map<String, Object> attrMap() {
        if (this.attrMap == null) {
            this.attrMap = new HashMap<String, Object>();
        }
        return this.attrMap;
    }

    @Override
    public <T> T attr(String name) {
        if (this.attrMap == null) {
            return null;
        }
        return (T)this.attrMap.get(name);
    }

    @Override
    public <T> T attrOrDefault(String name, T def) {
        T tmp = this.attr(name);
        if (tmp == null) {
            return def;
        }
        return tmp;
    }

    @Override
    public <T> void attr(String name, T value) {
        if (this.attrMap == null) {
            this.attrMap = new HashMap<String, Object>();
        }
        this.attrMap.put(name, value);
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Session)) {
            return false;
        }
        Session that = (Session)o;
        return Objects.equals(this.sessionId(), that.sessionId());
    }

    public int hashCode() {
        return Objects.hash(this.sessionId());
    }

    protected String generateId() {
        return this.channel.getConfig().getIdGenerator().generate();
    }
}

