/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.socketd.exception.SocketdCodecException;
import org.noear.socketd.transport.core.Constants;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.utils.IoUtils;
import org.noear.socketd.utils.Utils;

public class EntityDefault
implements Entity {
    private Map<String, String> metaMap;
    private String metaString = "";
    private boolean metaStringChanged = false;
    private InputStream data = Constants.DEF_DATA;
    private int dataSize = 0;
    private String dataAsString;

    public EntityDefault metaString(String metaString) {
        this.metaMap = null;
        this.metaString = metaString;
        this.metaStringChanged = false;
        return this;
    }

    @Override
    public String metaString() {
        if (this.metaStringChanged) {
            StringBuilder buf = new StringBuilder();
            this.metaMap().forEach((name, val) -> buf.append((String)name).append("=").append((String)val).append("&"));
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            this.metaString = buf.toString();
            this.metaStringChanged = false;
        }
        return this.metaString;
    }

    public EntityDefault metaMap(Map<String, String> metaMap) {
        this.metaMap = metaMap;
        this.metaString = null;
        this.metaStringChanged = true;
        return this;
    }

    @Override
    public Map<String, String> metaMap() {
        if (this.metaMap == null) {
            this.metaMap = new LinkedHashMap<String, String>();
            this.metaStringChanged = false;
            if (Utils.isNotEmpty(this.metaString)) {
                for (String kvStr : this.metaString.split("&")) {
                    int idx = kvStr.indexOf(61);
                    if (idx <= 0) continue;
                    this.metaMap.put(kvStr.substring(0, idx), kvStr.substring(idx + 1));
                }
            }
        }
        return this.metaMap;
    }

    public EntityDefault meta(String name, String val) {
        this.metaMap().put(name, val);
        this.metaStringChanged = true;
        return this;
    }

    @Override
    public String meta(String name) {
        return this.metaMap().get(name);
    }

    @Override
    public String metaOrDefault(String name, String def) {
        return this.metaMap().getOrDefault(name, def);
    }

    public EntityDefault data(byte[] data) {
        this.data = new ByteArrayInputStream(data);
        this.dataSize = data.length;
        return this;
    }

    public EntityDefault data(InputStream data) throws IOException {
        this.data = data;
        this.dataSize = data.available();
        this.meta("Data-Length", String.valueOf(this.dataSize));
        return this;
    }

    @Override
    public InputStream data() {
        return this.data;
    }

    @Override
    public String dataAsString() {
        try {
            if (this.dataAsString == null) {
                this.dataAsString = IoUtils.transferToString(this.data());
            }
            return this.dataAsString;
        }
        catch (IOException e) {
            throw new SocketdCodecException(e);
        }
    }

    @Override
    public byte[] dataAsBytes() {
        try {
            return IoUtils.transferToBytes(this.data());
        }
        catch (IOException e) {
            throw new SocketdCodecException(e);
        }
    }

    @Override
    public int dataSize() {
        return this.dataSize;
    }

    public String toString() {
        return "Entity{meta='" + this.metaString() + '\'' + ", data=byte[" + this.dataSize + ']' + '}';
    }
}

