/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.fragment;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.socketd.exception.SocketdCodecException;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.fragment.FragmentHolder;
import org.noear.socketd.transport.core.internal.MessageDefault;
import org.noear.socketd.utils.IoUtils;
import org.noear.socketd.utils.Utils;

public class FragmentAggregator {
    private Frame main;
    private List<FragmentHolder> fragmentHolders = new ArrayList<FragmentHolder>();
    private int dataStreamSize;
    private int dataLength;

    public FragmentAggregator(Frame main) {
        this.main = main;
        String dataLengthStr = main.getMessage().meta("Data-Length");
        if (Utils.isEmpty(dataLengthStr)) {
            throw new SocketdCodecException("Missing 'Data-Length' meta, topic=" + main.getMessage().topic());
        }
        this.dataLength = Integer.parseInt(dataLengthStr);
    }

    public String getSid() {
        return this.main.getMessage().sid();
    }

    public int getDataStreamSize() {
        return this.dataStreamSize;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public Frame get() throws IOException {
        this.fragmentHolders.sort(Comparator.comparing(fh -> fh.getIndex()));
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream(this.dataLength);
        for (FragmentHolder fh2 : this.fragmentHolders) {
            IoUtils.transferTo(fh2.getFrame().getMessage().data(), dataStream);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(dataStream.toByteArray());
        return new Frame(this.main.getFlag(), new MessageDefault().flag(this.main.getFlag()).sid(this.main.getMessage().sid()).topic(this.main.getMessage().topic()).entity(new EntityDefault().metaMap(this.main.getMessage().metaMap()).data(inputStream)));
    }

    public void add(int index, Frame frame) throws IOException {
        this.fragmentHolders.add(new FragmentHolder(index, frame));
        this.dataStreamSize += frame.getMessage().dataSize();
    }
}

