/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.fragment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.FragmentHandler;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.fragment.FragmentAggregator;
import org.noear.socketd.utils.IoUtils;

public class FragmentHandlerDefault
implements FragmentHandler {
    @Override
    public Entity nextFragment(Config config, AtomicReference<Integer> fragmentIndex, Entity entity) throws IOException {
        fragmentIndex.set(fragmentIndex.get() + 1);
        ByteArrayOutputStream fragmentBuf = new ByteArrayOutputStream();
        IoUtils.transferTo(entity.data(), fragmentBuf, 0L, 0x1000000L);
        byte[] fragmentBytes = fragmentBuf.toByteArray();
        if (fragmentBytes.length == 0) {
            return null;
        }
        EntityDefault fragmentEntity = new EntityDefault().data(fragmentBytes);
        if (fragmentIndex.get() == 1) {
            fragmentEntity.metaMap(entity.metaMap());
        }
        fragmentEntity.meta("Data-Fragment-Idx", String.valueOf(fragmentIndex));
        return fragmentEntity;
    }

    @Override
    public Frame aggrFragment(Channel channel, int index, Frame frame) throws IOException {
        FragmentAggregator aggregator = (FragmentAggregator)channel.getAttachment(frame.getMessage().sid());
        if (aggregator == null) {
            aggregator = new FragmentAggregator(frame);
            channel.setAttachment(aggregator.getSid(), aggregator);
        }
        aggregator.add(index, frame);
        if (aggregator.getDataLength() > aggregator.getDataStreamSize()) {
            return null;
        }
        return aggregator.get();
    }
}

