/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.noear.socketd.transport.core.Acceptor;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelBase;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Flag;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.internal.MessageDefault;
import org.noear.socketd.transport.core.internal.ProcessorDefault;
import org.noear.socketd.transport.core.internal.SessionDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelDefault<S>
extends ChannelBase
implements ChannelInternal {
    private static Logger log = LoggerFactory.getLogger(ProcessorDefault.class);
    private final S source;
    private final Map<String, Acceptor> acceptorMap;
    private final ChannelAssistant<S> assistant;
    private Session session;

    public ChannelDefault(S source, Config config, ChannelAssistant<S> assistant) {
        super(config);
        this.source = source;
        this.assistant = assistant;
        this.acceptorMap = new ConcurrentHashMap<String, Acceptor>();
    }

    @Override
    public void removeAcceptor(String sid) {
        Acceptor acceptor = this.acceptorMap.remove(sid);
        if (acceptor != null && log.isDebugEnabled()) {
            log.debug("The acceptor is actively removed, sid={}", (Object)sid);
        }
    }

    @Override
    public boolean isValid() {
        return !this.isClosed() && this.assistant.isValid(this.source);
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        return this.assistant.getRemoteAddress(this.source);
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        return this.assistant.getLocalAddress(this.source);
    }

    @Override
    public synchronized void send(Frame frame, Acceptor acceptor) throws IOException {
        Asserts.assertClosed(this);
        if (log.isDebugEnabled()) {
            if (this.getConfig().clientMode()) {
                log.debug("C-SEN:{}", (Object)frame);
            } else {
                log.debug("S-SEN:{}", (Object)frame);
            }
        }
        if (frame.getMessage() != null) {
            Message message = frame.getMessage();
            if (acceptor != null) {
                this.acceptorMap.put(message.sid(), acceptor);
            }
            if (message.entity() != null) {
                try (InputStream ins = message.data();){
                    if (message.dataSize() > 0x1000000) {
                        AtomicReference<Integer> fragmentIndex = new AtomicReference<Integer>(0);
                        while (true) {
                            Entity fragmentEntity;
                            if ((fragmentEntity = this.getConfig().getFragmentHandler().nextFragment(this.getConfig(), fragmentIndex, message.entity())) == null) {
                                return;
                            }
                            Frame fragmentFrame = new Frame(frame.getFlag(), new MessageDefault().flag(frame.getFlag()).sid(message.sid()).entity(fragmentEntity));
                            this.assistant.write(this.source, fragmentFrame);
                        }
                    }
                    this.assistant.write(this.source, frame);
                    return;
                }
            }
        }
        this.assistant.write(this.source, frame);
    }

    @Override
    public void retrieve(Frame frame, Consumer<Throwable> onError) {
        Acceptor acceptor = this.acceptorMap.get(frame.getMessage().sid());
        if (acceptor != null) {
            if (acceptor.isSingle() || frame.getFlag() == Flag.ReplyEnd) {
                this.acceptorMap.remove(frame.getMessage().sid());
            }
            if (acceptor.isSingle()) {
                acceptor.accept(frame.getMessage(), onError);
            } else {
                this.getConfig().getChannelExecutor().submit(() -> acceptor.accept(frame.getMessage(), onError));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Acceptor not found, sid={}", (Object)frame.getMessage().sid());
        }
    }

    @Override
    public void reconnect() throws Exception {
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            this.session = new SessionDefault(this);
        }
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("The channel will be closed, sessionId={}", (Object)this.getSession().sessionId());
        }
        super.close();
        this.acceptorMap.clear();
        this.assistant.close(this.source);
    }
}

