/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.listener;

import java.io.IOException;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.listener.BuilderListener;
import org.noear.socketd.transport.core.listener.Router;
import org.noear.socketd.transport.core.listener.RouterHashMap;

public class RouterListener
implements Listener {
    protected final Router router;

    public RouterListener() {
        this.router = new RouterHashMap();
    }

    public RouterListener(Router router) {
        this.router = router;
    }

    public RouterListener of(String path, Listener listener) {
        this.router.add(path, listener);
        return this;
    }

    public BuilderListener of(String path) {
        BuilderListener l1 = new BuilderListener();
        this.router.add(path, l1);
        return l1;
    }

    public int count() {
        return this.router.count();
    }

    @Override
    public void onOpen(Session session) throws IOException {
        Listener l1 = this.router.matching(session.path());
        if (l1 != null) {
            l1.onOpen(session);
        }
    }

    @Override
    public void onMessage(Session session, Message message) throws IOException {
        Listener l1 = this.router.matching(session.path());
        if (l1 != null) {
            l1.onMessage(session, message);
        }
    }

    @Override
    public void onClose(Session session) {
        Listener l1 = this.router.matching(session.path());
        if (l1 != null) {
            l1.onClose(session);
        }
    }

    @Override
    public void onError(Session session, Throwable error) {
        Listener l1 = this.router.matching(session.path());
        if (l1 != null) {
            l1.onError(session, error);
        }
    }
}

