/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.server;

import org.noear.socketd.transport.core.ConfigBase;
import org.noear.socketd.utils.Utils;

public class ServerConfig
extends ConfigBase<ServerConfig> {
    private final String schema;
    private String host;
    private int port;

    public ServerConfig(String schema) {
        super(false);
        if (schema.startsWith("sd:")) {
            schema = schema.substring(3);
        }
        this.schema = schema;
        this.host = "";
        this.port = 8602;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHost() {
        return this.host;
    }

    public ServerConfig host(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ServerConfig port(int port) {
        this.port = port;
        return this;
    }

    public String getLocalUrl() {
        if (Utils.isEmpty(this.host)) {
            return this.schema + "://127.0.0.1:" + this.port;
        }
        return this.schema + "://" + this.host + ":" + this.port;
    }

    public String toString() {
        return "ServerConfig{schema='" + this.schema + '\'' + ", charset=" + this.charset + ", host='" + this.host + '\'' + ", port=" + this.port + ", coreThreads=" + this.coreThreads + ", maxThreads=" + this.maxThreads + ", idleTimeout=" + this.idleTimeout + ", replyTimeout=" + this.requestTimeout + ", readBufferSize=" + this.readBufferSize + ", writeBufferSize=" + this.writeBufferSize + ", maxRequests=" + this.maxRequests + ", maxUdpSize=" + this.maxUdpSize + '}';
    }
}

