/*
 * Copyright 2017-2025 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.ai.generate.dialect;

import org.noear.solon.ai.AiModelDialect;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GenerateOptions;
import org.noear.solon.ai.generate.GenerateResponse;
import org.noear.solon.lang.Preview;

import java.util.Map;

/**
 * 生成模型方言
 *
 * @author noear
 * @since 3.5
 */
@Preview("3.5")
public interface GenerateDialect extends AiModelDialect {
    /**
     * 是否为默认
     */
    default boolean isDefault() {
        return false;
    }

    /**
     * 匹配检测
     *
     * @param config 聊天配置
     */
    boolean matched(GenerateConfig config);

    /**
     * 构建请求数据
     *
     * @param config    聊天配置
     * @param options   聊天选项
     * @param promptStr 提示语文本形态
     * @param promptMap 提示语字典形态
     */
    String buildRequestJson(GenerateConfig config, GenerateOptions options, String promptStr, Map promptMap);

    /**
     * 分析响应数据
     *
     * @param config   聊天配置
     * @param respJson 响应数据
     */
    GenerateResponse parseResponseJson(GenerateConfig config, String respJson);
}
