/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiModel;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatRequestDesc;
import org.noear.solon.ai.chat.ChatRequestDescDefault;
import org.noear.solon.ai.chat.ChatSession;
import org.noear.solon.ai.chat.dialect.ChatDialect;
import org.noear.solon.ai.chat.dialect.ChatDialectManager;
import org.noear.solon.ai.chat.interceptor.ChatInterceptor;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.prompt.ChatPrompt;
import org.noear.solon.ai.chat.session.InMemoryChatSession;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.FunctionToolDesc;
import org.noear.solon.ai.chat.tool.MethodToolProvider;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.Assert;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class ChatModel
implements AiModel {
    private final ChatConfig config;
    private final ChatDialect dialect;

    public ChatModel(Properties properties) {
        this((ChatConfig)Props.from((Properties)properties).bindTo((Object)new ChatConfig()));
    }

    public ChatModel(ChatConfig config) {
        Assert.notNull((Object)config, (String)"The config is required");
        Assert.notNull((Object)config.getApiUrl(), (String)"The config.apiUrl is required");
        Assert.notNull((Object)config.getModel(), (String)"The config.model is required");
        this.config = config;
        this.dialect = ChatDialectManager.select(config);
        Assert.notNull((Object)this.dialect, (String)"The dialect(provider) no matched, check config or dependencies");
    }

    public ChatRequestDesc prompt(ChatPrompt prompt) {
        if (prompt instanceof ChatSession) {
            return new ChatRequestDescDefault(this.config, this.dialect, (ChatSession)prompt);
        }
        return new ChatRequestDescDefault(this.config, this.dialect, InMemoryChatSession.builder().messages(prompt.getMessages()).build());
    }

    public ChatRequestDesc prompt(List<ChatMessage> messages) {
        return this.prompt(InMemoryChatSession.builder().messages(messages).build());
    }

    public ChatRequestDesc prompt(ChatMessage ... messages) {
        return this.prompt(Utils.asList((Object[])messages));
    }

    public ChatRequestDesc prompt(String content) {
        return this.prompt(ChatMessage.ofUser(content));
    }

    public String toString() {
        return "ChatModel{config=" + this.config + ", dialect=" + this.dialect.getClass().getName() + '}';
    }

    public static Builder of(ChatConfig config) {
        return new Builder(config);
    }

    public static Builder of(String apiUrl) {
        return new Builder(apiUrl);
    }

    public static class Builder {
        private final ChatConfig config;

        public Builder(String apiUrl) {
            this.config = new ChatConfig();
            this.config.setApiUrl(apiUrl);
        }

        public Builder(ChatConfig config) {
            this.config = config;
        }

        public Builder apiKey(String apiKey) {
            this.config.setApiKey(apiKey);
            return this;
        }

        public Builder provider(String provider) {
            this.config.setProvider(provider);
            return this;
        }

        public Builder model(String model) {
            this.config.setModel(model);
            return this;
        }

        public Builder headerSet(String key, String value) {
            this.config.setHeader(key, value);
            return this;
        }

        public Builder defaultToolsAdd(FunctionTool tool) {
            this.config.addDefaultTools(tool);
            return this;
        }

        public Builder defaultToolsAdd(Iterable<FunctionTool> toolColl) {
            for (FunctionTool f : toolColl) {
                this.config.addDefaultTools(f);
            }
            return this;
        }

        public Builder defaultToolsAdd(ToolProvider toolProvider) {
            return this.defaultToolsAdd(toolProvider.getTools());
        }

        public Builder defaultToolsAdd(Object toolObj) {
            return this.defaultToolsAdd(new MethodToolProvider(toolObj));
        }

        public Builder defaultToolsAdd(String name, Consumer<FunctionToolDesc> toolBuilder) {
            FunctionToolDesc decl = new FunctionToolDesc(name);
            toolBuilder.accept(decl);
            this.config.addDefaultTools(decl);
            return this;
        }

        public Builder defaultToolsContextAdd(String key, Object value) {
            this.config.addDefaultToolsContext(key, value);
            return this;
        }

        public Builder defaultToolsContextAdd(Map<String, Object> toolsContext) {
            this.config.addDefaultToolsContext(toolsContext);
            return this;
        }

        public Builder defaultInterceptorAdd(ChatInterceptor interceptor) {
            return this.defaultInterceptorAdd(0, interceptor);
        }

        public Builder defaultInterceptorAdd(int index, ChatInterceptor interceptor) {
            this.config.addDefaultInterceptor(index, interceptor);
            return this;
        }

        public Builder defaultOptionAdd(String key, Object val) {
            this.config.addDefaultOption(key, val);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.config.setTimeout(timeout);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.config.setProxy(proxy);
            return this;
        }

        public Builder proxy(String host, int port) {
            return this.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
        }

        public ChatModel build() {
            return new ChatModel(this.config);
        }
    }
}

