/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.solon.ai.chat.interceptor.ChatInterceptor;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.FunctionToolDesc;
import org.noear.solon.ai.chat.tool.MethodToolProvider;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.lang.Nullable;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class ChatOptions {
    public static final String MAX_TOKENS = "max_tokens";
    public static final String MAX_COMPLETION_TOKENS = "max_completion_tokens";
    public static final String TEMPERATURE = "temperature";
    public static final String TOP_P = "top_p";
    public static final String TOP_K = "top_k";
    public static final String FREQUENCY_PENALTY = "frequency_penalty";
    public static final String PRESENCE_PENALTY = "presence_penalty";
    public static final String TOOL_CHOICE = "tool_choice";
    public static final String RESPONSE_FORMAT = "response_format";
    private final Map<String, FunctionTool> tools = new LinkedHashMap<String, FunctionTool>();
    private final Map<String, Object> toolsContext = new LinkedHashMap<String, Object>();
    private final List<RankEntity<ChatInterceptor>> interceptors = new ArrayList<RankEntity<ChatInterceptor>>();
    private final Map<String, Object> options = new LinkedHashMap<String, Object>();

    public static ChatOptions of() {
        return new ChatOptions();
    }

    public Collection<FunctionTool> tools() {
        return this.tools.values();
    }

    public Map<String, Object> toolsContext() {
        return this.toolsContext;
    }

    public FunctionTool tool(String name) {
        return this.tools.get(name);
    }

    public ChatOptions toolsAdd(FunctionTool tool) {
        this.tools.put(tool.name(), tool);
        return this;
    }

    public ChatOptions toolsAdd(Iterable<FunctionTool> toolColl) {
        for (FunctionTool f : toolColl) {
            this.tools.put(f.name(), f);
        }
        return this;
    }

    public ChatOptions toolsAdd(ToolProvider toolProvider) {
        return this.toolsAdd(toolProvider.getTools());
    }

    public ChatOptions toolsAdd(Object toolObj) {
        return this.toolsAdd(new MethodToolProvider(toolObj));
    }

    public ChatOptions toolsAdd(String name, Consumer<FunctionToolDesc> toolBuilder) {
        FunctionToolDesc decl = new FunctionToolDesc(name);
        toolBuilder.accept(decl);
        this.tools.put(decl.name(), decl);
        return this;
    }

    public ChatOptions toolsContext(Map<String, Object> toolsContext) {
        this.toolsContext.putAll(toolsContext);
        return this;
    }

    public ChatOptions interceptorAdd(ChatInterceptor interceptor) {
        return this.interceptorAdd(0, interceptor);
    }

    public ChatOptions interceptorAdd(int index, ChatInterceptor interceptor) {
        this.interceptors.add((RankEntity<ChatInterceptor>)new RankEntity((Object)interceptor, index));
        return this;
    }

    public List<RankEntity<ChatInterceptor>> interceptors() {
        return this.interceptors;
    }

    public Map<String, Object> options() {
        return this.options;
    }

    public Object option(String key) {
        return this.options.get(key);
    }

    public ChatOptions optionAdd(String key, Object val) {
        this.options.put(key, val);
        return this;
    }

    public ChatOptions tool_choice(String choiceOrName) {
        if (choiceOrName == null) {
            this.optionAdd(TOOL_CHOICE, "none");
        } else if ("none".equals(choiceOrName)) {
            this.optionAdd(TOOL_CHOICE, "none");
        } else if ("auto".equals(choiceOrName)) {
            this.optionAdd(TOOL_CHOICE, "auto");
        } else if ("required".equals(choiceOrName)) {
            this.optionAdd(TOOL_CHOICE, "required");
        } else {
            HashMap<String, Object> choiceMap = new HashMap<String, Object>();
            choiceMap.put("type", "function");
            choiceMap.put("function", Collections.singletonMap("name", choiceOrName));
            this.optionAdd(TOOL_CHOICE, choiceMap);
        }
        return this;
    }

    public ChatOptions max_tokens(long max_tokens) {
        return this.optionAdd(MAX_TOKENS, max_tokens);
    }

    public ChatOptions max_completion_tokens(long max_completion_tokens) {
        return this.optionAdd(MAX_COMPLETION_TOKENS, max_completion_tokens);
    }

    public ChatOptions temperature(float temperature) {
        return this.optionAdd(TEMPERATURE, Float.valueOf(temperature));
    }

    public ChatOptions top_p(float top_p) {
        return this.optionAdd(TOP_P, Float.valueOf(top_p));
    }

    public ChatOptions top_k(float top_k) {
        return this.optionAdd(TOP_K, Float.valueOf(top_k));
    }

    public ChatOptions frequency_penalty(float frequency_penalty) {
        return this.optionAdd(FREQUENCY_PENALTY, Float.valueOf(frequency_penalty));
    }

    public ChatOptions presence_penalty(float frequency_penalty) {
        return this.optionAdd(PRESENCE_PENALTY, Float.valueOf(frequency_penalty));
    }

    public ChatOptions response_format(Map map) {
        return this.optionAdd(RESPONSE_FORMAT, map);
    }

    public ChatOptions user(String user) {
        return this.optionAdd("user", user);
    }

    @Nullable
    public String user() {
        return (String)this.option("user");
    }
}

