/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ChatSubscriberProxy<T>
implements Subscriber<T> {
    private final Subscriber<T> subscriber;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);

    private ChatSubscriberProxy(Subscriber<T> subscriber) {
        this.subscriber = subscriber;
    }

    public static <T> Subscriber<T> of(Subscriber<T> subscriber) {
        if (subscriber instanceof ChatSubscriberProxy) {
            return subscriber;
        }
        return new ChatSubscriberProxy<T>(subscriber);
    }

    public void onSubscribe(Subscription subscription) {
        if (this.subscribed.compareAndSet(false, true)) {
            this.subscriber.onSubscribe(subscription);
        } else {
            subscription.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T t) {
        this.subscriber.onNext(t);
    }

    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }
}

