/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.dialect.ChatDialect;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.RankEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatDialectManager {
    static final Logger log = LoggerFactory.getLogger(ChatDialectManager.class);
    private static List<RankEntity<ChatDialect>> dialects = new ArrayList<RankEntity<ChatDialect>>();
    private static ChatDialect defaultDialect;

    public static ChatDialect select(ChatConfig config) {
        if (config != null) {
            for (RankEntity<ChatDialect> d : dialects) {
                if (!((ChatDialect)d.target).matched(config)) continue;
                return (ChatDialect)d.target;
            }
        }
        return defaultDialect;
    }

    public static void register(ChatDialect dialect) {
        ChatDialectManager.register(dialect, 0);
    }

    public static void register(ChatDialect dialect, int index) {
        if (dialect != null) {
            dialects.add((RankEntity<ChatDialect>)new RankEntity((Object)dialect, index));
            Collections.sort(dialects);
            if (defaultDialect == null || dialect.isDefault()) {
                defaultDialect = dialect;
            }
            log.debug("Register chat dialect: {}", dialect.getClass());
        }
    }

    public static void unregister(ChatDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        ChatDialectManager.register((ChatDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.dashscope.DashscopeChatDialect"));
        ChatDialectManager.register((ChatDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.ollama.OllamaChatDialect"));
        ChatDialectManager.register((ChatDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.openai.OpenaiChatDialect"));
    }
}

