/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.ToolHandler;
import org.noear.solon.ai.chat.tool.ToolSchemaUtil;
import org.noear.solon.ai.util.ParamDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionToolDesc
implements FunctionTool {
    static final Logger log = LoggerFactory.getLogger(FunctionToolDesc.class);
    private final String name;
    private String title;
    private String description;
    private final List<ParamDesc> params = new ArrayList<ParamDesc>();
    private Type returnType;
    private boolean returnDirect = false;
    private ToolHandler doHandler;
    private String inputSchema;
    private String outputSchema;

    public FunctionToolDesc(String name, String title, String description, Boolean returnDirect, String inputSchema, String outputSchema, ToolHandler handler) {
        this.name = name;
        this.title = title;
        this.description = description;
        this.inputSchema = inputSchema;
        this.outputSchema = outputSchema;
        this.doHandler = handler;
        this.returnDirect = returnDirect == null ? false : returnDirect;
    }

    public FunctionToolDesc(String name) {
        this.name = name;
    }

    public FunctionToolDesc title(String title) {
        this.title = title;
        return this;
    }

    public FunctionToolDesc description(String description) {
        this.description = description;
        return this;
    }

    public FunctionToolDesc returnType(Type returnType) {
        this.returnType = returnType;
        this.outputSchema = null;
        return this;
    }

    public FunctionToolDesc returnDirect(boolean returnDirect) {
        this.returnDirect = returnDirect;
        return this;
    }

    public FunctionToolDesc paramAdd(String name, Type type, String description) {
        return this.paramAdd(name, type, true, description);
    }

    public FunctionToolDesc paramAdd(String name, Type type, boolean required, String description) {
        this.params.add(new ParamDesc(name, type, required, description));
        this.inputSchema = null;
        return this;
    }

    public FunctionToolDesc stringParamAdd(String name, String description) {
        return this.paramAdd(name, (Type)((Object)String.class), description);
    }

    public FunctionToolDesc intParamAdd(String name, String description) {
        return this.paramAdd(name, Integer.TYPE, description);
    }

    public FunctionToolDesc floatParamAdd(String name, String description) {
        return this.paramAdd(name, Float.TYPE, description);
    }

    public FunctionToolDesc boolParamAdd(String name, String description) {
        return this.paramAdd(name, (Type)((Object)Boolean.class), description);
    }

    public FunctionToolDesc dateParamAdd(String name, String description) {
        return this.paramAdd(name, (Type)((Object)Date.class), description);
    }

    public FunctionToolDesc doHandle(ToolHandler handler) {
        this.doHandler = handler;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public boolean returnDirect() {
        return this.returnDirect;
    }

    @Override
    public String inputSchema() {
        if (this.inputSchema == null) {
            this.inputSchema = ToolSchemaUtil.buildInputSchema(this.params);
        }
        return this.inputSchema;
    }

    @Override
    public String outputSchema() {
        if (this.outputSchema == null && this.returnType != null) {
            this.outputSchema = !ToolSchemaUtil.isIgnoreOutputSchema(this.returnType) ? ToolSchemaUtil.buildOutputSchema(this.returnType) : "";
        }
        return this.outputSchema;
    }

    @Override
    public String handle(Map<String, Object> args) throws Throwable {
        try {
            return this.doHandle(args);
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            if (log.isWarnEnabled()) {
                log.warn("Tool handle error, name: '{}'", (Object)this.name, (Object)ex);
            }
            throw ex;
        }
    }

    private String doHandle(Map<String, Object> args) throws Throwable {
        if (this.params.size() > 0) {
            HashMap<String, Object> argsNew = new HashMap<String, Object>();
            ONode argsNode = ONode.load(args);
            for (ParamDesc p1 : this.params) {
                ONode v1 = argsNode.getOrNull(p1.name());
                if (v1 == null) {
                    argsNew.put(p1.name(), null);
                    continue;
                }
                argsNew.put(p1.name(), v1.toObject(p1.type()));
            }
            return this.doHandler.handle(argsNew);
        }
        return this.doHandler.handle(args);
    }

    public String toString() {
        return "FunctionToolDesc{name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", returnDirect=" + this.returnDirect + ", inputSchema=" + this.inputSchema() + ", outputSchema=" + this.outputSchema() + '}';
    }
}

