/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.ai.annotation.ToolMapping;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.MethodExecuteHandler;
import org.noear.solon.ai.chat.tool.ToolCallResultConverter;
import org.noear.solon.ai.chat.tool.ToolCallResultConverterDefault;
import org.noear.solon.ai.chat.tool.ToolSchemaUtil;
import org.noear.solon.ai.util.ParamDesc;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.wrap.MethodWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodFunctionTool
implements FunctionTool {
    static final Logger log = LoggerFactory.getLogger(MethodFunctionTool.class);
    private final BeanWrap beanWrap;
    private final MethodWrap methodWrap;
    private final Type returnType;
    private final String name;
    private final String title;
    private final String description;
    private final boolean returnDirect;
    private final List<ParamDesc> params = new ArrayList<ParamDesc>();
    private final ToolCallResultConverter resultConverter;
    private final String inputSchema;
    private String outputSchema;

    public MethodFunctionTool(BeanWrap beanWrap, Method method) {
        this.beanWrap = beanWrap;
        this.methodWrap = new MethodWrap(beanWrap.context(), method.getDeclaringClass(), method);
        this.returnType = method.getGenericReturnType();
        ToolMapping mapping = method.getAnnotation(ToolMapping.class);
        Assert.notNull((Object)mapping, (String)"@ToolMapping annotation is missing");
        Assert.notEmpty((String)mapping.description(), (String)"ToolMapping description cannot be empty");
        this.name = Utils.annoAlias((String)mapping.name(), (String)method.getName());
        this.title = mapping.title();
        this.description = mapping.description();
        this.returnDirect = mapping.returnDirect();
        this.resultConverter = mapping.resultConverter() == ToolCallResultConverter.class || mapping.resultConverter() == ToolCallResultConverterDefault.class ? ToolCallResultConverterDefault.getInstance() : (Solon.context() != null ? (ToolCallResultConverter)Solon.context().getBeanOrNew(mapping.resultConverter()) : (ToolCallResultConverter)ClassUtil.newInstance(mapping.resultConverter()));
        for (Parameter p1 : method.getParameters()) {
            ParamDesc toolParam = ToolSchemaUtil.paramOf(p1);
            if (toolParam == null) continue;
            this.params.add(toolParam);
        }
        this.inputSchema = ToolSchemaUtil.buildInputSchema(this.params);
        Type returnType = method.getGenericReturnType();
        this.outputSchema = !ToolSchemaUtil.isIgnoreOutputSchema(returnType) ? ToolSchemaUtil.buildOutputSchema(returnType) : "";
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public boolean returnDirect() {
        return this.returnDirect;
    }

    @Override
    public String inputSchema() {
        return this.inputSchema;
    }

    @Override
    public String outputSchema() {
        return this.outputSchema;
    }

    @Override
    public String handle(Map<String, Object> args) throws Throwable {
        try {
            return this.doHandle(args);
        }
        catch (Throwable ex) {
            if (log.isWarnEnabled()) {
                log.warn("Tool handle error, name: '{}'", (Object)this.name, (Object)ex);
            }
            throw ex;
        }
    }

    private String doHandle(Map<String, Object> args) throws Throwable {
        Context ctx = Context.current();
        if (ctx == null) {
            ctx = new ContextEmpty();
        }
        ctx.attrSet("MCP_BODY", args);
        ctx.result = MethodExecuteHandler.getInstance().executeHandle(ctx, this.beanWrap.get(), this.methodWrap);
        if (this.resultConverter == null) {
            return String.valueOf(ctx.result);
        }
        return this.resultConverter.convert(ctx.result, this.returnType);
    }

    public String toString() {
        return "MethodFunctionTool{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", returnDirect=" + this.returnDirect + ", inputSchema=" + this.inputSchema() + ", outputSchema=" + this.outputSchema() + '}';
    }
}

