/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.generate.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.dialect.GenerateDialect;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.lang.Preview;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Preview(value="3.5")
public class GenerateDialectManager {
    static final Logger log = LoggerFactory.getLogger(GenerateDialectManager.class);
    private static List<RankEntity<GenerateDialect>> dialects = new ArrayList<RankEntity<GenerateDialect>>();
    private static GenerateDialect defaultDialect;

    public static GenerateDialect select(GenerateConfig config) {
        for (RankEntity<GenerateDialect> d : dialects) {
            if (!((GenerateDialect)d.target).matched(config)) continue;
            return (GenerateDialect)d.target;
        }
        return defaultDialect;
    }

    public static void register(GenerateDialect dialect) {
        GenerateDialectManager.register(dialect, 0);
    }

    public static void register(GenerateDialect dialect, int index) {
        if (dialect != null) {
            dialects.add((RankEntity<GenerateDialect>)new RankEntity((Object)dialect, index));
            Collections.sort(dialects);
            if (defaultDialect == null || dialect.isDefault()) {
                defaultDialect = dialect;
            }
            log.debug("Register generate dialect: {}", dialect.getClass());
        }
    }

    public static void unregister(GenerateDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        GenerateDialectManager.register((GenerateDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.dashscope.DashscopeGenerateDialect"));
        GenerateDialectManager.register((GenerateDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.ollama.OllamaGenerateDialect"));
        GenerateDialectManager.register((GenerateDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.openai.OpenaiGenerateDialect"));
    }
}

