/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImageOptions;
import org.noear.solon.ai.image.ImageResponse;
import org.noear.solon.ai.image.dialect.ImageDialect;
import org.noear.solon.net.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRequestDesc {
    private static final Logger log = LoggerFactory.getLogger(ImageRequestDesc.class);
    private final ImageConfig config;
    private final ImageDialect dialect;
    private final String promptStr;
    private final Map promptMap;
    private ImageOptions options;

    protected ImageRequestDesc(ImageConfig config, ImageDialect dialect, String promptStr, Map promptMap) {
        this.config = config;
        this.dialect = dialect;
        this.promptStr = promptStr;
        this.promptMap = promptMap;
        this.options = new ImageOptions();
    }

    public ImageRequestDesc options(ImageOptions options) {
        if (options != null) {
            this.options = options;
        }
        return this;
    }

    public ImageRequestDesc options(Consumer<ImageOptions> optionsBuilder) {
        optionsBuilder.accept(this.options);
        return this;
    }

    public ImageResponse call() throws IOException {
        ImageResponse resp;
        HttpUtils httpUtils = this.config.createHttpUtils();
        String reqJson = this.dialect.buildRequestJson(this.config, this.options, this.promptStr, this.promptMap);
        if (log.isDebugEnabled()) {
            log.debug("ai-request: {}", (Object)reqJson);
        }
        String respJson = httpUtils.bodyOfJson(reqJson).post();
        if (log.isDebugEnabled()) {
            log.debug("ai-response: {}", (Object)respJson);
        }
        if ((resp = this.dialect.parseResponseJson(this.config, respJson)).getError() != null) {
            throw resp.getError();
        }
        return resp;
    }
}

