/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.ai.AiConfig;
import org.noear.solon.ai.chat.interceptor.ChatInterceptor;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.core.util.RankEntity;

public class ChatConfig
extends AiConfig {
    private final Map<String, FunctionTool> defaultTools = new LinkedHashMap<String, FunctionTool>();
    private final Map<String, Object> defaultToolsContext = new LinkedHashMap<String, Object>();
    private final List<RankEntity<ChatInterceptor>> defaultInterceptors = new ArrayList<RankEntity<ChatInterceptor>>();
    private final Map<String, Object> defaultOptions = new LinkedHashMap<String, Object>();

    public void setDefaultTools(Map<String, FunctionTool> tools) {
        if (tools != null) {
            this.defaultTools.putAll(tools);
        }
    }

    public void addDefaultTools(FunctionTool tool) {
        this.defaultTools.put(tool.name(), tool);
    }

    public void addDefaultTools(Collection<FunctionTool> toolColl) {
        for (FunctionTool f : toolColl) {
            this.defaultTools.put(f.name(), f);
        }
    }

    public FunctionTool getDefaultTool(String name) {
        return this.defaultTools.get(name);
    }

    public Collection<FunctionTool> getDefaultTools() {
        return this.defaultTools.values();
    }

    public void addDefaultToolsContext(String key, Object value) {
        this.defaultToolsContext.put(key, value);
    }

    public void addDefaultToolsContext(Map<String, Object> toolsContext) {
        this.defaultToolsContext.putAll(toolsContext);
    }

    public Map<String, Object> getDefaultToolsContext() {
        return this.defaultToolsContext;
    }

    public void addDefaultInterceptor(int index, ChatInterceptor interceptor) {
        this.defaultInterceptors.add((RankEntity<ChatInterceptor>)new RankEntity((Object)interceptor, index));
    }

    public List<RankEntity<ChatInterceptor>> getDefaultInterceptors() {
        return this.defaultInterceptors;
    }

    public void addDefaultOption(String key, Object value) {
        this.defaultOptions.put(key, value);
    }

    public Map<String, Object> getDefaultOptions() {
        return this.defaultOptions;
    }

    @Override
    public String toString() {
        return "ChatConfig{apiUrl='" + this.apiUrl + '\'' + ", apiKey='" + this.apiKey + '\'' + ", provider='" + this.provider + '\'' + ", model='" + this.model + '\'' + ", headers=" + this.headers + ", timeout=" + this.timeout + ", proxy=" + this.getProxy() + ", defaultTools=" + this.defaultTools + '}';
    }
}

