/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.net.Proxy;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.interceptor.ChatInterceptor;
import org.noear.solon.ai.chat.tool.FunctionTool;

public class ChatConfigReadonly {
    private final ChatConfig config;

    public ChatConfigReadonly(ChatConfig config) {
        this.config = config;
    }

    public String getApiKey() {
        return this.config.getApiKey();
    }

    public String getApiUrl() {
        return this.config.getApiUrl();
    }

    public String getProvider() {
        return this.config.getProvider();
    }

    public String getModel() {
        return this.config.getModel();
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.config.getHeaders());
    }

    public Duration getTimeout() {
        return this.config.getTimeout();
    }

    public Proxy getProxy() {
        return this.config.getProxy();
    }

    public FunctionTool getDefaultTool(String name) {
        return this.config.getDefaultTool(name);
    }

    public Collection<FunctionTool> getDefaultTools() {
        return this.config.getDefaultTools();
    }

    public List<ChatInterceptor> getDefaultInterceptors() {
        return this.config.getDefaultInterceptors().stream().map(e -> (ChatInterceptor)e.target).collect(Collectors.toList());
    }
}

