/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatConfigReadonly;
import org.noear.solon.ai.chat.ChatOptions;
import org.noear.solon.ai.chat.dialect.ChatDialect;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.core.util.Assert;

public class ChatRequest {
    private final ChatConfig config;
    private final ChatConfigReadonly configReadonly;
    private final ChatDialect dialect;
    private final ChatOptions options;
    private final boolean stream;
    private List<ChatMessage> messages;

    public ChatRequest(ChatConfig config, ChatDialect dialect, ChatOptions options, boolean stream, List<ChatMessage> messages) {
        this.config = config;
        this.configReadonly = new ChatConfigReadonly(config);
        this.dialect = dialect;
        this.options = options;
        this.stream = stream;
        this.messages = messages;
    }

    public ChatConfigReadonly getConfig() {
        return this.configReadonly;
    }

    public ChatOptions getOptions() {
        return this.options;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setMessages(List<ChatMessage> messages) {
        Assert.notEmpty(messages, (String)"messages is empty");
        this.messages = messages;
    }

    public List<ChatMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public String toRequestData() {
        String reqJson = this.dialect.buildRequestJson(this.config, this.options, this.messages, this.stream);
        return reqJson;
    }
}

