/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.ChatMessageBase;
import org.noear.solon.ai.chat.tool.ToolCall;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class AssistantMessage
extends ChatMessageBase<AssistantMessage> {
    private final ChatRole role = ChatRole.ASSISTANT;
    private String content;
    private List<ToolCall> toolCalls;
    private List<Map> toolCallsRaw;
    private List<Map> searchResultsRaw;
    private Object contentRaw;
    private boolean isThinking;
    private transient String resultContent;

    public AssistantMessage() {
    }

    public AssistantMessage(String content) {
        this(content, false, null, null, null, null);
    }

    public AssistantMessage(String content, boolean isThinking) {
        this(content, isThinking, null, null, null, null);
    }

    public AssistantMessage(String content, boolean isThinking, List<Map> searchResultsRaw) {
        this(content, isThinking, null, null, null, searchResultsRaw);
    }

    public AssistantMessage(String content, boolean isThinking, Object contentRaw, List<Map> toolCallsRaw, List<ToolCall> toolCalls, List<Map> searchResultsRaw) {
        this.content = content;
        this.isThinking = isThinking;
        this.toolCallsRaw = toolCallsRaw;
        this.toolCalls = toolCalls;
        this.searchResultsRaw = searchResultsRaw;
        this.contentRaw = contentRaw == null ? content : contentRaw;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public Object getContentRaw() {
        return this.contentRaw;
    }

    public String getResultContent() {
        if (this.resultContent == null) {
            int thinkIndex;
            this.resultContent = this.content == null ? "" : ((thinkIndex = this.content.indexOf("</think>")) > -1 ? this.content.substring(thinkIndex + 8).trim() : this.content);
        }
        return this.resultContent;
    }

    @Override
    public boolean isThinking() {
        return this.isThinking;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public List<Map> getToolCallsRaw() {
        return this.toolCallsRaw;
    }

    public List<Map> getSearchResultsRaw() {
        return this.searchResultsRaw;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("role=").append(this.getRole().name().toLowerCase());
        if (this.isThinking) {
            buf.append(", is_thinking=true");
        }
        if (this.content != null) {
            buf.append(", content='").append(this.content).append('\'');
        }
        if (this.contentRaw != null) {
            buf.append(", contentRaw=").append(this.contentRaw);
        }
        if (Utils.isNotEmpty((Map)this.metadata)) {
            buf.append(", metadata=").append(this.metadata);
        }
        if (this.toolCallsRaw != null) {
            buf.append(", tool_calls=").append(this.toolCallsRaw);
        }
        if (this.searchResultsRaw != null) {
            buf.append(", search_results=").append(this.searchResultsRaw);
        }
        buf.append("}");
        return buf.toString();
    }
}

