/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.ChatMessageBase;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class ToolMessage
extends ChatMessageBase<ToolMessage> {
    private final ChatRole role = ChatRole.TOOL;
    private String content;
    private String name;
    private String toolCallId;
    private transient boolean returnDirect;

    public ToolMessage() {
    }

    public ToolMessage(String content, String name, String toolCallId, boolean returnDirect) {
        this.content = content;
        this.name = name;
        this.toolCallId = toolCallId;
        this.returnDirect = returnDirect;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public boolean isReturnDirect() {
        return this.returnDirect;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("role=").append(this.getRole().name().toLowerCase());
        if (this.content != null) {
            buf.append(", content='").append(this.content).append('\'');
        }
        if (Utils.isNotEmpty((Map)this.metadata)) {
            buf.append(", metadata=").append(this.metadata);
        }
        if (this.name != null) {
            buf.append(", name='").append(this.name).append('\'');
        }
        if (this.toolCallId != null) {
            buf.append(", tool_call_id=").append(this.toolCallId);
        }
        buf.append("}");
        return buf.toString();
    }
}

