/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.util.ParamDesc;
import org.noear.solon.annotation.Param;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.lang.Nullable;

public class ToolSchemaUtil {
    public static final String TYPE_OBJECT = "object";
    public static final String TYPE_ARRAY = "array";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_NULL = "null";

    @Nullable
    public static ParamDesc paramOf(AnnotatedElement ae) {
        Param p1Anno = ae.getAnnotation(Param.class);
        if (p1Anno == null) {
            return null;
        }
        if (ae instanceof Parameter) {
            Parameter p1 = (Parameter)ae;
            String name = Utils.annoAlias((String)p1Anno.name(), (String)p1.getName());
            return new ParamDesc(name, p1.getParameterizedType(), p1Anno.required(), p1Anno.description());
        }
        Field p1 = (Field)ae;
        String name = Utils.annoAlias((String)p1Anno.name(), (String)p1.getName());
        return new ParamDesc(name, p1.getGenericType(), p1Anno.required(), p1Anno.description());
    }

    public static String buildInputSchema(List<ParamDesc> toolParams) {
        return ToolSchemaUtil.buildToolParametersNode(toolParams, new ONode()).toJson();
    }

    public static String buildOutputSchema(Type type) {
        return ToolSchemaUtil.buildTypeSchemaNode(type, "", new ONode()).toJson();
    }

    public static ONode buildToolParametersNode(List<ParamDesc> toolParams, ONode schemaParentNode) {
        schemaParentNode.asObject();
        ONode requiredNode = new ONode(schemaParentNode.options()).asArray();
        schemaParentNode.set("type", (Object)TYPE_OBJECT);
        schemaParentNode.getOrNew("properties").build(propertiesNode -> {
            propertiesNode.asObject();
            for (ParamDesc fp : toolParams) {
                propertiesNode.getOrNew(fp.name()).build(paramNode -> ToolSchemaUtil.buildTypeSchemaNode(fp.type(), fp.description(), paramNode));
                if (!fp.required()) continue;
                requiredNode.add((Object)fp.name());
            }
        });
        schemaParentNode.set("required", (Object)requiredNode);
        return schemaParentNode;
    }

    public static ONode buildTypeSchemaNode(Type type, String description, ONode schemaNode) {
        if (type instanceof ParameterizedType) {
            ToolSchemaUtil.handleParameterizedType((ParameterizedType)type, description, schemaNode);
        } else if (type instanceof Class) {
            ToolSchemaUtil.handleClassType((Class)type, description, schemaNode);
        } else {
            schemaNode.set("type", (Object)TYPE_STRING);
        }
        if (Utils.isNotEmpty((String)description)) {
            schemaNode.set("description", (Object)description);
        }
        return schemaNode;
    }

    public static boolean isIgnoreOutputSchema(Type type) {
        if (type == Void.TYPE) {
            return true;
        }
        if (type == String.class) {
            return true;
        }
        if (type == Boolean.class) {
            return true;
        }
        if (type instanceof Class) {
            Class clz = (Class)type;
            if (Number.class.isAssignableFrom(clz)) {
                return true;
            }
            if (Date.class.isAssignableFrom(clz)) {
                return true;
            }
            return clz.isPrimitive() || clz.isEnum();
        }
        return false;
    }

    private static void handleParameterizedType(ParameterizedType pt, String description, ONode schemaNode) {
        Type[] actualTypes;
        Type rawType = pt.getRawType();
        if (!(rawType instanceof Class)) {
            schemaNode.set("type", (Object)TYPE_OBJECT);
            return;
        }
        Class clazz = (Class)rawType;
        if (Collection.class.isAssignableFrom(clazz)) {
            ToolSchemaUtil.handleGenericCollection(pt, schemaNode);
            return;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            ToolSchemaUtil.handleGenericMap(pt, schemaNode);
            return;
        }
        if (ToolSchemaUtil.isOptionalType(rawType)) {
            ToolSchemaUtil.buildTypeSchemaNode(pt.getActualTypeArguments()[0], description, schemaNode);
            return;
        }
        TypeVariable<Class<T>>[] typeParams = clazz.getTypeParameters();
        if (typeParams.length == (actualTypes = pt.getActualTypeArguments()).length) {
            ToolSchemaUtil.resolveGenericClassWithTypeArgs(clazz, actualTypes, schemaNode);
            return;
        }
        schemaNode.set("type", (Object)TYPE_OBJECT);
    }

    private static void resolveGenericClassWithTypeArgs(Class<?> clazz, Type[] actualTypes, ONode schemaNode) {
        TypeVariable<Class<?>>[] typeParams = clazz.getTypeParameters();
        HashMap<String, Type> typeVarMap = new HashMap<String, Type>();
        for (int i = 0; i < typeParams.length; ++i) {
            typeVarMap.put(typeParams[i].getName(), actualTypes[i]);
        }
        schemaNode.set("type", (Object)TYPE_OBJECT);
        ONode props = schemaNode.getNew("properties");
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            Type fieldType = field.getGenericType();
            if (fieldType instanceof TypeVariable && typeVarMap.containsKey(((TypeVariable)fieldType).getName())) {
                TypeVariable tv = (TypeVariable)fieldType;
                fieldType = (Type)typeVarMap.get(tv.getName());
            }
            ONode fieldSchema = new ONode();
            ToolSchemaUtil.buildTypeSchemaNode(fieldType, null, fieldSchema);
            props.set(field.getName(), (Object)fieldSchema);
        }
    }

    private static void handleClassType(Class<?> clazz, String description, ONode schemaNode) {
        if (clazz.isArray()) {
            schemaNode.set("type", (Object)TYPE_ARRAY);
            ToolSchemaUtil.buildTypeSchemaNode(clazz.getComponentType(), null, schemaNode.getOrNew("items"));
            return;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            schemaNode.set("type", (Object)TYPE_ARRAY);
            return;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            schemaNode.set("type", (Object)TYPE_OBJECT);
            return;
        }
        if (clazz.isEnum()) {
            ToolSchemaUtil.handleEnumType(clazz, schemaNode);
            return;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            schemaNode.set("type", (Object)TYPE_STRING);
            schemaNode.set("format", (Object)"date-time");
            return;
        }
        if (URI.class.isAssignableFrom(clazz)) {
            schemaNode.set("type", (Object)TYPE_STRING);
            schemaNode.set("format", (Object)"uri");
            return;
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            schemaNode.set("type", (Object)TYPE_INTEGER);
            return;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            schemaNode.set("type", (Object)TYPE_NUMBER);
            return;
        }
        ToolSchemaUtil.handleObjectType(clazz, schemaNode);
    }

    private static void handleGenericCollection(ParameterizedType pt, ONode schemaNode) {
        schemaNode.set("type", (Object)TYPE_ARRAY);
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        if (actualTypeArguments.length > 0) {
            ToolSchemaUtil.buildTypeSchemaNode(actualTypeArguments[0], null, schemaNode.getOrNew("items"));
        }
    }

    private static void handleGenericMap(ParameterizedType pt, ONode schemaNode) {
        schemaNode.set("type", (Object)TYPE_OBJECT);
    }

    private static void handleEnumType(Class<?> clazz, ONode schemaNode) {
        schemaNode.set("type", (Object)TYPE_STRING);
        schemaNode.getOrNew("enum").build(n -> {
            for (Object e : clazz.getEnumConstants()) {
                n.add((Object)e.toString());
            }
        });
    }

    private static void handleObjectType(Class<?> clazz, ONode schemaNode) {
        String typeStr = ToolSchemaUtil.jsonTypeOfJavaType(clazz);
        schemaNode.set("type", (Object)typeStr);
        if (!TYPE_OBJECT.equals(typeStr)) {
            return;
        }
        ONode requiredNode = new ONode(schemaNode.options()).asArray();
        schemaNode.getOrNew("properties").build(propertiesNode -> {
            propertiesNode.asObject();
            for (FieldWrap fw : ClassWrap.get((Class)clazz).getAllFieldWraps()) {
                ParamDesc fp = ToolSchemaUtil.paramOf(fw.getField());
                if (fp == null) continue;
                propertiesNode.getOrNew(fp.name()).build(paramNode -> ToolSchemaUtil.buildTypeSchemaNode(fp.type(), fp.description(), paramNode));
                if (!fp.required()) continue;
                requiredNode.add((Object)fp.name());
            }
        });
        schemaNode.set("required", (Object)requiredNode);
    }

    private static boolean isOptionalType(Type rawType) {
        return rawType.getTypeName().startsWith("java.util.Optional");
    }

    public static String jsonTypeOfJavaType(Class<?> type) {
        if (type.equals(String.class) || type.equals(Date.class) || type.equals(BigDecimal.class) || type.equals(BigInteger.class)) {
            return TYPE_STRING;
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE)) {
            return TYPE_INTEGER;
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Number.class)) {
            return TYPE_NUMBER;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return TYPE_BOOLEAN;
        }
        return TYPE_OBJECT;
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Deprecated
    public static void buildToolParamNode(Type type, String description, ONode schemaNode) {
        ToolSchemaUtil.buildTypeSchemaNode(type, description, schemaNode);
    }
}

