/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.embedding;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.noear.solon.ai.embedding.EmbeddingConfig;
import org.noear.solon.ai.embedding.EmbeddingOptions;
import org.noear.solon.ai.embedding.EmbeddingResponse;
import org.noear.solon.ai.embedding.dialect.EmbeddingDialect;
import org.noear.solon.net.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddingRequestDesc {
    private static final Logger log = LoggerFactory.getLogger(EmbeddingRequestDesc.class);
    private final EmbeddingConfig config;
    private final EmbeddingDialect dialect;
    private final List<String> input;
    private EmbeddingOptions options;

    protected EmbeddingRequestDesc(EmbeddingConfig config, EmbeddingDialect dialect, List<String> input) {
        this.config = config;
        this.dialect = dialect;
        this.input = input;
        this.options = new EmbeddingOptions();
    }

    public EmbeddingRequestDesc options(EmbeddingOptions options) {
        if (options != null) {
            this.options = options;
        }
        return this;
    }

    public EmbeddingRequestDesc options(Consumer<EmbeddingOptions> optionsBuilder) {
        optionsBuilder.accept(this.options);
        return this;
    }

    public EmbeddingResponse call() throws IOException {
        EmbeddingResponse resp;
        HttpUtils httpUtils = this.config.createHttpUtils();
        String reqJson = this.dialect.buildRequestJson(this.config, this.options, this.input);
        if (log.isDebugEnabled()) {
            log.debug("ai-request: {}", (Object)reqJson);
        }
        String respJson = httpUtils.bodyOfJson(reqJson).post();
        if (log.isDebugEnabled()) {
            log.debug("ai-response: {}", (Object)respJson);
        }
        if ((resp = this.dialect.parseResponseJson(this.config, respJson)).getError() != null) {
            throw resp.getError();
        }
        return resp;
    }
}

