/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.embedding.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.embedding.EmbeddingConfig;
import org.noear.solon.ai.embedding.dialect.EmbeddingDialect;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.RankEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddingDialectManager {
    static final Logger log = LoggerFactory.getLogger(EmbeddingDialectManager.class);
    private static List<RankEntity<EmbeddingDialect>> dialects = new ArrayList<RankEntity<EmbeddingDialect>>();
    private static EmbeddingDialect defaultDialect;

    public static EmbeddingDialect select(EmbeddingConfig config) {
        for (RankEntity<EmbeddingDialect> d : dialects) {
            if (!((EmbeddingDialect)d.target).matched(config)) continue;
            return (EmbeddingDialect)d.target;
        }
        return defaultDialect;
    }

    public static void register(EmbeddingDialect dialect) {
        EmbeddingDialectManager.register(dialect, 0);
    }

    public static void register(EmbeddingDialect dialect, int index) {
        if (dialect != null) {
            dialects.add((RankEntity<EmbeddingDialect>)new RankEntity((Object)dialect, index));
            Collections.sort(dialects);
            if (defaultDialect == null || dialect.isDefault()) {
                defaultDialect = dialect;
            }
            log.debug("Register embedding dialect: {}", dialect.getClass());
        }
    }

    public static void unregister(EmbeddingDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        EmbeddingDialectManager.register((EmbeddingDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.dashscope.DashscopeEmbeddingDialect"));
        EmbeddingDialectManager.register((EmbeddingDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.ollama.OllamaEmbeddingDialect"));
        EmbeddingDialectManager.register((EmbeddingDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.openai.OpenaiEmbeddingDialect"));
    }
}

