/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.dialect.ImageDialect;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.RankEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDialectManager {
    static final Logger log = LoggerFactory.getLogger(ImageDialectManager.class);
    private static List<RankEntity<ImageDialect>> dialects = new ArrayList<RankEntity<ImageDialect>>();
    private static ImageDialect defaultDialect;

    public static ImageDialect select(ImageConfig config) {
        for (RankEntity<ImageDialect> d : dialects) {
            if (!((ImageDialect)d.target).matched(config)) continue;
            return (ImageDialect)d.target;
        }
        return defaultDialect;
    }

    public static void register(ImageDialect dialect) {
        ImageDialectManager.register(dialect, 0);
    }

    public static void register(ImageDialect dialect, int index) {
        if (dialect != null) {
            dialects.add((RankEntity<ImageDialect>)new RankEntity((Object)dialect, index));
            Collections.sort(dialects);
            if (defaultDialect == null || dialect.isDefault()) {
                defaultDialect = dialect;
            }
            log.debug("Register image dialect: {}", dialect.getClass());
        }
    }

    public static void unregister(ImageDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        ImageDialectManager.register((ImageDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.dashscope.DashscopeImageDialect"));
        ImageDialectManager.register((ImageDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.ollama.OllamaImageDialect"));
        ImageDialectManager.register((ImageDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.openai.OpenaiImageDialect"));
    }
}

