/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.media;

import java.util.Base64;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.media.AbstractMedia;

public class Image
extends AbstractMedia
implements AiMedia {
    @Override
    public String getMimeType() {
        if (Utils.isEmpty((String)this.mimeType)) {
            return "image/jpeg";
        }
        return this.mimeType;
    }

    public static Image ofUrl(String url) {
        Image tmp = new Image();
        tmp.url = url;
        return tmp;
    }

    public static Image ofBase64(String base64String) {
        Image tmp = new Image();
        tmp.b64_json = base64String;
        return tmp;
    }

    public static Image ofBase64(String base64String, String mimeType) {
        Image tmp = new Image();
        tmp.b64_json = base64String;
        tmp.mimeType = mimeType;
        return tmp;
    }

    public static Image ofBase64(byte[] base64, String mimeType) {
        Image tmp = new Image();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        tmp.mimeType = mimeType;
        return tmp;
    }

    public static Image ofBase64(byte[] base64) {
        Image tmp = new Image();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        return tmp;
    }
}

