/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.media;

import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.media.Audio;
import org.noear.solon.ai.media.Image;
import org.noear.solon.ai.media.Video;

public class Text
implements AiMedia {
    private String content;
    private boolean isBase64;
    private String mimeType;

    public static Text of(boolean isBase64, String content) {
        Text tmp = new Text();
        tmp.isBase64 = isBase64;
        tmp.content = content;
        tmp.mimeType = null;
        return tmp;
    }

    public static Text of(boolean isBase64, String content, String mimeType) {
        Text tmp = new Text();
        tmp.isBase64 = isBase64;
        tmp.content = content;
        tmp.mimeType = mimeType;
        return tmp;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public String getContent() {
        return this.content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String toDataString(boolean useMime) {
        if (useMime && Utils.isNotEmpty((String)this.getMimeType())) {
            return "data:" + this.getMimeType() + ";base64," + this.getContent();
        }
        return this.getContent();
    }

    @Override
    public Map<String, Object> toData(boolean useMime) {
        if (useMime && Utils.isNotEmpty((String)this.getMimeType())) {
            return Utils.asMap((Object[])new Object[]{"mimeType", this.getMimeType(), "data", this.getContent()});
        }
        return Utils.asMap((Object[])new Object[]{"data", this.getContent()});
    }

    public String toString() {
        return "Text{content='" + this.content + '\'' + ", isBase64=" + this.isBase64 + ", mimeType='" + this.mimeType + '\'' + '}';
    }

    public Image toImage() {
        if (this.isBase64()) {
            return Image.ofBase64(this.getContent(), this.getMimeType());
        }
        return Image.ofUrl(this.getContent());
    }

    public Audio toAudio() {
        if (this.isBase64()) {
            return Audio.ofBase64(this.getContent(), this.getMimeType());
        }
        return Audio.ofUrl(this.getContent());
    }

    public Video toVideo() {
        if (this.isBase64()) {
            return Video.ofBase64(this.getContent(), this.getMimeType());
        }
        return Video.ofUrl(this.getContent());
    }
}

