/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.Repository;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public interface RepositoryStorable
extends Repository {
    default public CompletableFuture<Void> asyncSave(List<Document> documents, BiConsumer<Integer, Integer> progressCallback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RunUtil.async(() -> {
            try {
                this.save(documents, progressCallback);
                future.complete(null);
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    public void save(List<Document> var1, BiConsumer<Integer, Integer> var2) throws IOException;

    default public void save(List<Document> documents) throws IOException {
        this.save(documents, null);
    }

    default public void save(Document ... documents) throws IOException {
        this.save(Arrays.asList(documents));
    }

    public void deleteById(String ... var1) throws IOException;

    public boolean existsById(String var1) throws IOException;

    @Deprecated
    default public CompletableFuture<Void> asyncInsert(List<Document> documents, BiConsumer<Integer, Integer> progressCallback) {
        return this.asyncSave(documents, progressCallback);
    }

    @Deprecated
    default public void insert(List<Document> documents, BiConsumer<Integer, Integer> progressCallback) throws IOException {
        this.save(documents, progressCallback);
    }

    @Deprecated
    default public void insert(List<Document> documents) throws IOException {
        this.save(documents);
    }

    @Deprecated
    default public void insert(Document ... documents) throws IOException {
        this.save(documents);
    }

    @Deprecated
    default public void delete(String ... ids) throws IOException {
        this.deleteById(ids);
    }

    @Deprecated
    default public boolean exists(String id) throws IOException {
        return this.existsById(id);
    }
}

