/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.loader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.loader.AbstractOptionsDocumentLoader;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.SupplierEx;

public class TextLoader
extends AbstractOptionsDocumentLoader<Options, TextLoader> {
    private final SupplierEx<InputStream> source;

    public TextLoader(File file) throws IOException {
        this(file.toURI());
    }

    public TextLoader(URI uri) throws IOException {
        this(uri.toURL());
    }

    public TextLoader(URL url) {
        this((SupplierEx<InputStream>)((SupplierEx)() -> url.openStream()));
    }

    public TextLoader(byte[] bytes) {
        this((SupplierEx<InputStream>)((SupplierEx)() -> new ByteArrayInputStream(bytes)));
    }

    public TextLoader(SupplierEx<InputStream> source) {
        this.source = source;
        this.options = new Options();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Document> load() {
        try (InputStream stream = (InputStream)this.source.get();){
            String temp = IoUtil.transferToString((InputStream)stream, (String)((Options)this.options).charset);
            List<Document> list = Arrays.asList(new Document(temp).metadata(this.additionalMetadata));
            return list;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static class Options {
        private String charset = Solon.encoding();

        public Options charset(String charset) {
            this.charset = charset;
            return this;
        }
    }
}

