/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.ai.embedding.EmbeddingModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.RepositoryLifecycle;
import org.noear.solon.ai.rag.RepositoryStorable;
import org.noear.solon.ai.rag.util.ListUtil;
import org.noear.solon.ai.rag.util.QueryCondition;
import org.noear.solon.ai.rag.util.SimilarityUtil;

public class InMemoryRepository
implements RepositoryStorable,
RepositoryLifecycle {
    private final EmbeddingModel embeddingModel;
    private final Map<String, Document> store = new ConcurrentHashMap<String, Document>();

    public InMemoryRepository(EmbeddingModel embeddingModel) {
        this.embeddingModel = embeddingModel;
    }

    @Override
    public void save(List<Document> documents, BiConsumer<Integer, Integer> progressCallback) throws IOException {
        if (Utils.isEmpty(documents)) {
            if (progressCallback != null) {
                progressCallback.accept(0, 0);
            }
            return;
        }
        List<List<Document>> batchList = ListUtil.partition(documents, this.embeddingModel.batchSize());
        int batchIndex = 0;
        for (List<Document> batch : batchList) {
            this.embeddingModel.embed(batch);
            this.batchInsertDo(batch);
            if (progressCallback == null) continue;
            progressCallback.accept(++batchIndex, batchList.size());
        }
    }

    private void batchInsertDo(List<Document> batch) {
        for (Document doc : batch) {
            if (Utils.isEmpty((String)doc.getId())) {
                doc.id(Utils.uuid());
            }
            this.store.put(doc.getId(), doc);
        }
    }

    @Override
    public void initRepository() {
    }

    @Override
    public void dropRepository() {
        this.store.clear();
    }

    @Override
    public void deleteById(String ... ids) {
        for (String id : ids) {
            this.store.remove(id);
        }
    }

    @Override
    public boolean existsById(String id) {
        return this.store.containsKey(id);
    }

    @Override
    public List<Document> search(QueryCondition condition) throws IOException {
        float[] queryEmbed = this.embeddingModel.embed(condition.getQuery());
        return SimilarityUtil.refilter(this.store.values().stream().map(doc -> SimilarityUtil.copyAndScore(doc, queryEmbed)), condition);
    }
}

