/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.util;

public class HybridSearchParams {
    public static final HybridSearchParams DEFAULT = new HybridSearchParams(0.5, 0.5);
    private final double vectorWeight;
    private final double fullTextWeight;

    private HybridSearchParams() {
        this(0.5, 0.5);
    }

    private HybridSearchParams(double vectorWeight, double fullTextWeight) {
        this.vectorWeight = vectorWeight;
        this.fullTextWeight = fullTextWeight;
    }

    public double getVectorWeight() {
        return this.vectorWeight;
    }

    public double getFullTextWeight() {
        return this.fullTextWeight;
    }

    public static HybridSearchParams of(double vectorWeight) {
        double effectiveVectorWeight = Math.max(0.0, Math.min(1.0, vectorWeight));
        return new HybridSearchParams(effectiveVectorWeight, 1.0 - effectiveVectorWeight);
    }
}

