/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.util;

import org.noear.solon.ai.rag.util.Freshness;
import org.noear.solon.ai.rag.util.HybridSearchParams;
import org.noear.solon.ai.rag.util.SearchType;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.snel.SnEL;

public class QueryCondition {
    public static final int DEFAULT_LIMIT = 4;
    public static final double DEFAULT_SIMILARITY_THRESHOLD = 0.4;
    private final String query;
    private Freshness freshness;
    private int limit = 4;
    private double similarityThreshold = 0.4;
    private Expression<Boolean> filterExpression;
    private boolean disableRefilter;
    private SearchType searchType = SearchType.VECTOR;
    private HybridSearchParams hybridSearchParams;

    public QueryCondition(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public Freshness getFreshness() {
        return this.freshness;
    }

    public int getLimit() {
        return this.limit;
    }

    public double getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public Expression<Boolean> getFilterExpression() {
        return this.filterExpression;
    }

    public boolean isDisableRefilter() {
        return this.disableRefilter;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public HybridSearchParams getHybridSearchParams() {
        return this.hybridSearchParams;
    }

    public QueryCondition freshness(Freshness freshness) {
        this.freshness = freshness;
        return this;
    }

    public QueryCondition limit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryCondition filterExpression(Expression<Boolean> filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    public QueryCondition filterExpression(String filterExpression) {
        this.filterExpression = SnEL.parse((String)filterExpression);
        return this;
    }

    public QueryCondition similarityThreshold(double similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
        return this;
    }

    public QueryCondition disableRefilter(boolean disableRefilter) {
        this.disableRefilter = disableRefilter;
        return this;
    }

    public QueryCondition searchType(SearchType searchType) {
        if (searchType != null) {
            this.searchType = searchType;
            if (SearchType.HYBRID.equals((Object)searchType) && this.hybridSearchParams == null) {
                this.hybridSearchParams = HybridSearchParams.DEFAULT;
            }
        }
        return this;
    }

    public QueryCondition hybridSearchParams(HybridSearchParams hybridSearchParams) {
        this.hybridSearchParams = hybridSearchParams;
        return this;
    }
}

