/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.reranking.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.reranking.RerankingConfig;
import org.noear.solon.ai.reranking.dialect.RerankingDialect;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.RankEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RerankingDialectManager {
    static final Logger log = LoggerFactory.getLogger(RerankingDialectManager.class);
    private static List<RankEntity<RerankingDialect>> dialects = new ArrayList<RankEntity<RerankingDialect>>();
    private static RerankingDialect defaultDialect;

    public static RerankingDialect select(RerankingConfig config) {
        for (RankEntity<RerankingDialect> d : dialects) {
            if (!((RerankingDialect)d.target).matched(config)) continue;
            return (RerankingDialect)d.target;
        }
        return defaultDialect;
    }

    public static void register(RerankingDialect dialect) {
        RerankingDialectManager.register(dialect, 0);
    }

    public static void register(RerankingDialect dialect, int index) {
        if (dialect != null) {
            dialects.add((RankEntity<RerankingDialect>)new RankEntity((Object)dialect, index));
            Collections.sort(dialects);
            if (defaultDialect == null || dialect.isDefault()) {
                defaultDialect = dialect;
            }
            log.debug("Register reranking dialect: {}", dialect.getClass());
        }
    }

    public static void unregister(RerankingDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        RerankingDialectManager.register((RerankingDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.dashscope.DashscopeRerankingDialect"));
        RerankingDialectManager.register((RerankingDialect)ClassUtil.tryInstance((String)"org.noear.solon.ai.llm.dialect.openai.OpenaiRerankingDialect"));
    }
}

