/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.openai;

import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImageException;
import org.noear.solon.ai.image.ImageResponse;
import org.noear.solon.ai.image.dialect.AbstractImageDialect;
import org.noear.solon.ai.media.Image;

public class OpenaiImageDialect
extends AbstractImageDialect {
    private static OpenaiImageDialect instance = new OpenaiImageDialect();

    public static OpenaiImageDialect getInstance() {
        return instance;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean matched(ImageConfig config) {
        return false;
    }

    public ImageResponse parseResponseJson(ImageConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("error")) {
            return new ImageResponse(model, new ImageException(oResp.get("error").getString()), null, null);
        }
        List data = oResp.get("data").toObjectList(Image.class);
        AiUsage usage = null;
        if (oResp.contains("usage")) {
            ONode oUsage = oResp.get("usage");
            usage = new AiUsage((long)oUsage.get("prompt_tokens").getInt(), 0L, (long)oUsage.get("total_tokens").getInt());
        }
        return new ImageResponse(model, null, data, usage);
    }
}

