/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpNotificationHandler;
import io.modelcontextprotocol.server.McpRequestHandler;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.DefaultMcpStreamableServerSessionFactory;
import io.modelcontextprotocol.spec.JsonSchemaValidator;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerSession;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.spec.McpServerTransportProviderBase;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.DeafaultMcpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.McpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.Utils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class McpAsyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncServer.class);
    private final McpServerTransportProviderBase mcpTransportProvider;
    private final ObjectMapper objectMapper;
    private final JsonSchemaValidator jsonSchemaValidator;
    private final McpSchema.ServerCapabilities serverCapabilities;
    private final McpSchema.Implementation serverInfo;
    private final String instructions;
    private final CopyOnWriteArrayList<McpServerFeatures.AsyncToolSpecification> tools = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, McpServerFeatures.AsyncResourceSpecification> resources = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, McpServerFeatures.AsyncPromptSpecification> prompts = new ConcurrentHashMap();
    private McpSchema.LoggingLevel minLoggingLevel = McpSchema.LoggingLevel.DEBUG;
    private final ConcurrentHashMap<McpSchema.CompleteReference, McpServerFeatures.AsyncCompletionSpecification> completions = new ConcurrentHashMap();
    private List<String> protocolVersions;
    private McpUriTemplateManagerFactory uriTemplateManagerFactory = new DeafaultMcpUriTemplateManagerFactory();

    public McpAsyncServer(McpServerTransportProvider mcpTransportProvider, ObjectMapper objectMapper, McpServerFeatures.Async features, Duration requestTimeout, McpUriTemplateManagerFactory uriTemplateManagerFactory, JsonSchemaValidator jsonSchemaValidator) {
        this.mcpTransportProvider = mcpTransportProvider;
        this.objectMapper = objectMapper;
        this.serverInfo = features.getServerInfo();
        this.serverCapabilities = features.getServerCapabilities().mutate().logging().build();
        this.instructions = features.getInstructions();
        this.tools.addAll(McpAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, features.getTools()));
        this.resources.putAll(features.getResources());
        this.resourceTemplates.addAll(features.getResourceTemplates());
        this.prompts.putAll(features.getPrompts());
        this.completions.putAll(features.getCompletions());
        this.uriTemplateManagerFactory = uriTemplateManagerFactory;
        this.jsonSchemaValidator = jsonSchemaValidator;
        Map<String, McpRequestHandler<?>> requestHandlers = this.prepareRequestHandlers();
        Map<String, McpNotificationHandler> notificationHandlers = this.prepareNotificationHandlers(features);
        this.protocolVersions = mcpTransportProvider.protocolVersions();
        mcpTransportProvider.setSessionFactory(transport -> new McpServerSession(UUID.randomUUID().toString(), requestTimeout, transport, this::asyncInitializeRequestHandler, requestHandlers, notificationHandlers));
    }

    public McpAsyncServer(McpStreamableServerTransportProvider mcpTransportProvider, ObjectMapper objectMapper, McpServerFeatures.Async features, Duration requestTimeout, McpUriTemplateManagerFactory uriTemplateManagerFactory, JsonSchemaValidator jsonSchemaValidator) {
        this.mcpTransportProvider = mcpTransportProvider;
        this.objectMapper = objectMapper;
        this.serverInfo = features.getServerInfo();
        this.serverCapabilities = features.getServerCapabilities().mutate().logging().build();
        this.instructions = features.getInstructions();
        this.tools.addAll(McpAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, features.getTools()));
        this.resources.putAll(features.getResources());
        this.resourceTemplates.addAll(features.getResourceTemplates());
        this.prompts.putAll(features.getPrompts());
        this.completions.putAll(features.getCompletions());
        this.uriTemplateManagerFactory = uriTemplateManagerFactory;
        this.jsonSchemaValidator = jsonSchemaValidator;
        Map<String, McpRequestHandler<?>> requestHandlers = this.prepareRequestHandlers();
        Map<String, McpNotificationHandler> notificationHandlers = this.prepareNotificationHandlers(features);
        this.protocolVersions = mcpTransportProvider.protocolVersions();
        mcpTransportProvider.setSessionFactory(new DefaultMcpStreamableServerSessionFactory(requestTimeout, this::asyncInitializeRequestHandler, requestHandlers, notificationHandlers));
    }

    private Map<String, McpNotificationHandler> prepareNotificationHandlers(McpServerFeatures.Async features) {
        HashMap<String, McpNotificationHandler> notificationHandlers = new HashMap<String, McpNotificationHandler>();
        notificationHandlers.put("notifications/initialized", (exchange, params) -> Mono.empty());
        List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers = features.getRootsChangeConsumers();
        if (Utils.isEmpty(rootsChangeConsumers)) {
            rootsChangeConsumers = Arrays.asList((exchange, roots) -> Mono.fromRunnable(() -> logger.warn("Roots list changed notification, but no consumers provided. Roots list changed: {}", roots)));
        }
        notificationHandlers.put("notifications/roots/list_changed", this.asyncRootsListChangedNotificationHandler(rootsChangeConsumers));
        return notificationHandlers;
    }

    private Map<String, McpRequestHandler<?>> prepareRequestHandlers() {
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("ping", (exchange, params) -> Mono.just(new HashMap()));
        if (this.serverCapabilities.getTools() != null) {
            requestHandlers.put("tools/list", this.toolsListRequestHandler());
            requestHandlers.put("tools/call", this.toolsCallRequestHandler());
        }
        if (this.serverCapabilities.getResources() != null) {
            requestHandlers.put("resources/list", this.resourcesListRequestHandler());
            requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
            requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
        }
        if (this.serverCapabilities.getPrompts() != null) {
            requestHandlers.put("prompts/list", this.promptsListRequestHandler());
            requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
        }
        if (this.serverCapabilities.getLogging() != null) {
            requestHandlers.put("logging/setLevel", this.setLoggerRequestHandler());
        }
        if (this.serverCapabilities.getCompletions() != null) {
            requestHandlers.put("completion/complete", this.completionCompleteRequestHandler());
        }
        return requestHandlers;
    }

    private Mono<McpSchema.InitializeResult> asyncInitializeRequestHandler(McpSchema.InitializeRequest initializeRequest) {
        return Mono.defer(() -> {
            logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.getProtocolVersion(), initializeRequest.getCapabilities(), initializeRequest.getClientInfo()});
            String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
            if (this.protocolVersions.contains(initializeRequest.getProtocolVersion())) {
                serverProtocolVersion = initializeRequest.getProtocolVersion();
            } else {
                logger.warn("Client requested unsupported protocol version: {}, so the server will suggest the {} version instead", (Object)initializeRequest.getProtocolVersion(), (Object)serverProtocolVersion);
            }
            return Mono.just((Object)new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, this.instructions));
        });
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.serverCapabilities;
    }

    public McpSchema.Implementation getServerInfo() {
        return this.serverInfo;
    }

    public Mono<Void> closeGracefully() {
        return this.mcpTransportProvider.closeGracefully();
    }

    public void close() {
        this.mcpTransportProvider.close();
    }

    private McpNotificationHandler asyncRootsListChangedNotificationHandler(List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
        return (exchange, params) -> exchange.listRoots().flatMap(listRootsResult -> Flux.fromIterable((Iterable)rootsChangeConsumers).flatMap(consumer -> Mono.defer(() -> (Mono)consumer.apply(exchange, listRootsResult.getRoots()))).onErrorResume(error -> {
            logger.error("Error handling roots list change notification", error);
            return Mono.empty();
        }).then());
    }

    public Mono<Void> addTool(McpServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool specification must not be null"));
        }
        if (toolSpecification.getTool() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool must not be null"));
        }
        if (toolSpecification.getCall() == null && toolSpecification.getCallHandler() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool call handler must not be null"));
        }
        if (this.serverCapabilities.getTools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        McpServerFeatures.AsyncToolSpecification wrappedToolSpecification = McpAsyncServer.withStructuredOutputHandling(this.jsonSchemaValidator, toolSpecification);
        return Mono.defer(() -> {
            if (this.tools.stream().anyMatch(th -> th.getTool().getName().equals(wrappedToolSpecification.getTool().getName()))) {
                return Mono.error((Throwable)new McpError((Object)("Tool with name '" + wrappedToolSpecification.getTool().getName() + "' already exists")));
            }
            this.tools.add(wrappedToolSpecification);
            logger.debug("Added tool handler: {}", (Object)wrappedToolSpecification.getTool().getName());
            if (this.serverCapabilities.getTools().getListChanged().booleanValue()) {
                return this.notifyToolsListChanged();
            }
            return Mono.empty();
        });
    }

    private static List<McpServerFeatures.AsyncToolSpecification> withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, List<McpServerFeatures.AsyncToolSpecification> tools) {
        if (Utils.isEmpty(tools)) {
            return tools;
        }
        return tools.stream().map(tool -> McpAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, tool)).collect(Collectors.toList());
    }

    private static McpServerFeatures.AsyncToolSpecification withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, McpServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification.getCallHandler() instanceof StructuredOutputCallToolHandler) {
            return toolSpecification;
        }
        if (toolSpecification.getTool().getOutputSchema() == null) {
            return toolSpecification;
        }
        return McpServerFeatures.AsyncToolSpecification.builder().tool(toolSpecification.getTool()).callHandler(new StructuredOutputCallToolHandler(jsonSchemaValidator, toolSpecification.getTool().getOutputSchema(), toolSpecification.getCallHandler())).build();
    }

    public Mono<Void> removeTool(String toolName) {
        if (toolName == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool name must not be null"));
        }
        if (this.serverCapabilities.getTools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        return Mono.defer(() -> {
            boolean removed = this.tools.removeIf(toolSpecification -> toolSpecification.getTool().getName().equals(toolName));
            if (removed) {
                logger.debug("Removed tool handler: {}", (Object)toolName);
                if (this.serverCapabilities.getTools().getListChanged().booleanValue()) {
                    return this.notifyToolsListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolName + "' not found")));
        });
    }

    public Mono<Void> notifyToolsListChanged() {
        return this.mcpTransportProvider.notifyClients("notifications/tools/list_changed", null);
    }

    private McpRequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
        return (exchange, params) -> {
            List<McpSchema.Tool> tools = this.tools.stream().map(McpServerFeatures.AsyncToolSpecification::getTool).collect(Collectors.toList());
            return Mono.just((Object)new McpSchema.ListToolsResult(tools, null));
        };
    }

    private McpRequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
        return (exchange, params) -> {
            McpSchema.CallToolRequest callToolRequest = (McpSchema.CallToolRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.CallToolRequest>(){});
            Optional<McpServerFeatures.AsyncToolSpecification> toolSpecification = this.tools.stream().filter(tr -> callToolRequest.getName().equals(tr.getTool().getName())).findAny();
            if (!toolSpecification.isPresent()) {
                return Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.getName())));
            }
            return toolSpecification.map(tool -> Mono.defer(() -> tool.getCallHandler().apply(exchange, callToolRequest))).orElse(Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.getName()))));
        };
    }

    public Mono<Void> addResource(McpServerFeatures.AsyncResourceSpecification resourceSpecification) {
        if (resourceSpecification == null || resourceSpecification.getResource() == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource must not be null"));
        }
        if (this.serverCapabilities.getResources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            if (this.resources.putIfAbsent(resourceSpecification.getResource().getUri(), resourceSpecification) != null) {
                return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceSpecification.getResource().getUri() + "' already exists")));
            }
            logger.debug("Added resource handler: {}", (Object)resourceSpecification.getResource().getUri());
            if (this.serverCapabilities.getResources().getListChanged().booleanValue()) {
                return this.notifyResourcesListChanged();
            }
            return Mono.empty();
        });
    }

    public Mono<Void> removeResource(String resourceUri) {
        if (resourceUri == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource URI must not be null"));
        }
        if (this.serverCapabilities.getResources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncResourceSpecification removed = this.resources.remove(resourceUri);
            if (removed != null) {
                logger.debug("Removed resource handler: {}", (Object)resourceUri);
                if (this.serverCapabilities.getResources().getListChanged().booleanValue()) {
                    return this.notifyResourcesListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
        });
    }

    public Mono<Void> notifyResourcesListChanged() {
        return this.mcpTransportProvider.notifyClients("notifications/resources/list_changed", null);
    }

    public Mono<Void> notifyResourcesUpdated(McpSchema.ResourcesUpdatedNotification resourcesUpdatedNotification) {
        return this.mcpTransportProvider.notifyClients("notifications/resources/updated", resourcesUpdatedNotification);
    }

    private McpRequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
        return (exchange, params) -> {
            List<McpSchema.Resource> resourceList = this.resources.values().stream().map(McpServerFeatures.AsyncResourceSpecification::getResource).collect(Collectors.toList());
            return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
        };
    }

    private McpRequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
        return (exchange, params) -> Mono.just((Object)new McpSchema.ListResourceTemplatesResult(this.getResourceTemplates(), null));
    }

    private List<McpSchema.ResourceTemplate> getResourceTemplates() {
        ArrayList<McpSchema.ResourceTemplate> list = new ArrayList<McpSchema.ResourceTemplate>(this.resourceTemplates);
        List resourceTemplates = this.resources.keySet().stream().filter(uri -> uri.contains("{")).map(uri -> {
            McpSchema.Resource resource = this.resources.get(uri).getResource();
            McpSchema.ResourceTemplate template = new McpSchema.ResourceTemplate(resource.getUri(), resource.getName(), resource.getTitle(), resource.getDescription(), resource.getMimeType(), resource.getAnnotations());
            return template;
        }).collect(Collectors.toList());
        list.addAll(resourceTemplates);
        return list;
    }

    private McpRequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
        return (exchange, params) -> {
            McpSchema.ReadResourceRequest resourceRequest = (McpSchema.ReadResourceRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.ReadResourceRequest>(){});
            String resourceUri = resourceRequest.getUri();
            McpServerFeatures.AsyncResourceSpecification specification = this.resources.values().stream().filter(resourceSpecification -> this.uriTemplateManagerFactory.create(resourceSpecification.getResource().getUri()).matches(resourceUri)).findFirst().orElseThrow(() -> new McpError((Object)("Resource not found: " + resourceUri)));
            return Mono.defer(() -> specification.getReadHandler().apply(exchange, resourceRequest));
        };
    }

    public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptSpecification promptSpecification) {
        if (promptSpecification == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt specification must not be null"));
        }
        if (this.serverCapabilities.getPrompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncPromptSpecification specification = this.prompts.putIfAbsent(promptSpecification.getPrompt().getName(), promptSpecification);
            if (specification != null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptSpecification.getPrompt().getName() + "' already exists")));
            }
            logger.debug("Added prompt handler: {}", (Object)promptSpecification.getPrompt().getName());
            if (this.serverCapabilities.getPrompts().getListChanged().booleanValue()) {
                return this.notifyPromptsListChanged();
            }
            return Mono.empty();
        });
    }

    public Mono<Void> removePrompt(String promptName) {
        if (promptName == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt name must not be null"));
        }
        if (this.serverCapabilities.getPrompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncPromptSpecification removed = this.prompts.remove(promptName);
            if (removed != null) {
                logger.debug("Removed prompt handler: {}", (Object)promptName);
                if (this.serverCapabilities.getPrompts().getListChanged().booleanValue()) {
                    return this.notifyPromptsListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptName + "' not found")));
        });
    }

    public Mono<Void> notifyPromptsListChanged() {
        return this.mcpTransportProvider.notifyClients("notifications/prompts/list_changed", null);
    }

    private McpRequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
        return (exchange, params) -> {
            List<McpSchema.Prompt> promptList = this.prompts.values().stream().map(McpServerFeatures.AsyncPromptSpecification::getPrompt).collect(Collectors.toList());
            return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
        };
    }

    private McpRequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
        return (exchange, params) -> {
            McpSchema.GetPromptRequest promptRequest = (McpSchema.GetPromptRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.GetPromptRequest>(){});
            McpServerFeatures.AsyncPromptSpecification specification = this.prompts.get(promptRequest.getName());
            if (specification == null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptRequest.getName())));
            }
            return Mono.defer(() -> specification.getPromptHandler().apply(exchange, promptRequest));
        };
    }

    @Deprecated
    public Mono<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
        if (loggingMessageNotification == null) {
            return Mono.error((Throwable)new McpError((Object)"Logging message must not be null"));
        }
        if (loggingMessageNotification.getLevel().level() < this.minLoggingLevel.level()) {
            return Mono.empty();
        }
        return this.mcpTransportProvider.notifyClients("notifications/message", loggingMessageNotification);
    }

    private McpRequestHandler<Object> setLoggerRequestHandler() {
        return (exchange, params) -> Mono.defer(() -> {
            McpSchema.SetLevelRequest newMinLoggingLevel = (McpSchema.SetLevelRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.SetLevelRequest>(){});
            exchange.setMinLoggingLevel(newMinLoggingLevel.getLevel());
            this.minLoggingLevel = newMinLoggingLevel.getLevel();
            return Mono.just((Object)Utils.asMap(new Object[0]));
        });
    }

    private McpRequestHandler<McpSchema.CompleteResult> completionCompleteRequestHandler() {
        return (exchange, params) -> {
            McpServerFeatures.AsyncCompletionSpecification specification;
            McpSchema.CompleteRequest request = this.parseCompletionParams(params);
            if (request.getRef() == null) {
                return Mono.error((Throwable)new McpError((Object)"ref must not be null"));
            }
            if (request.getRef().getType() == null) {
                return Mono.error((Throwable)new McpError((Object)"type must not be null"));
            }
            String type = request.getRef().getType();
            String argumentName = request.getArgument().getName();
            if (type.equals("ref/prompt") && request.getRef() instanceof McpSchema.PromptReference) {
                McpSchema.PromptReference promptReference = (McpSchema.PromptReference)request.getRef();
                McpServerFeatures.AsyncPromptSpecification promptSpec = this.prompts.get(promptReference.getName());
                if (promptSpec == null) {
                    return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptReference.getName())));
                }
                if (!promptSpec.getPrompt().getArguments().stream().filter(arg -> arg.getName().equals(argumentName)).findFirst().isPresent()) {
                    return Mono.error((Throwable)new McpError((Object)("Argument not found: " + argumentName)));
                }
            }
            if (type.equals("ref/resource") && request.getRef() instanceof McpSchema.ResourceReference) {
                McpSchema.ResourceReference resourceReference = (McpSchema.ResourceReference)request.getRef();
                McpServerFeatures.AsyncResourceSpecification resourceSpec = this.resources.get(resourceReference.getUri());
                if (resourceSpec == null) {
                    return Mono.error((Throwable)new McpError((Object)("Resource not found: " + resourceReference.getUri())));
                }
                if (!this.uriTemplateManagerFactory.create(resourceSpec.getResource().getUri()).getVariableNames().contains(argumentName)) {
                    return Mono.error((Throwable)new McpError((Object)("Argument not found: " + argumentName)));
                }
            }
            if ((specification = this.completions.get(request.getRef())) == null) {
                return Mono.error((Throwable)new McpError((Object)("AsyncCompletionSpecification not found: " + request.getRef())));
            }
            return Mono.defer(() -> specification.getCompletionHandler().apply(exchange, request));
        };
    }

    private McpSchema.CompleteRequest parseCompletionParams(Object object) {
        McpSchema.CompleteReference ref;
        Map params = (Map)object;
        Map refMap = (Map)params.get("ref");
        Map argMap = (Map)params.get("argument");
        Map contextMap = (Map)params.get("context");
        Map meta = (Map)params.get("_meta");
        String refType = (String)refMap.get("type");
        if ("ref/prompt".equals(refType)) {
            ref = new McpSchema.PromptReference(refType, (String)refMap.get("name"), refMap.get("title") != null ? (String)refMap.get("title") : null);
        } else if ("ref/resource".equals(refType)) {
            ref = new McpSchema.ResourceReference(refType, (String)refMap.get("uri"));
        } else {
            throw new IllegalArgumentException("Invalid ref type: " + refType);
        }
        String argName = (String)argMap.get("name");
        String argValue = (String)argMap.get("value");
        McpSchema.CompleteRequest.CompleteArgument argument = new McpSchema.CompleteRequest.CompleteArgument(argName, argValue);
        McpSchema.CompleteRequest.CompleteContext context = null;
        if (contextMap != null) {
            Map arguments = (Map)contextMap.get("arguments");
            context = new McpSchema.CompleteRequest.CompleteContext(arguments);
        }
        return new McpSchema.CompleteRequest(ref, argument, meta, context);
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    private static class StructuredOutputCallToolHandler
    implements BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> {
        private final BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateCallToolResult;
        private final JsonSchemaValidator jsonSchemaValidator;
        private final Map<String, Object> outputSchema;

        public StructuredOutputCallToolHandler(JsonSchemaValidator jsonSchemaValidator, Map<String, Object> outputSchema, BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateHandler) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            Assert.notNull(delegateHandler, "Delegate call tool result handler must not be null");
            this.delegateCallToolResult = delegateHandler;
            this.outputSchema = outputSchema;
            this.jsonSchemaValidator = jsonSchemaValidator;
        }

        @Override
        public Mono<McpSchema.CallToolResult> apply(McpAsyncServerExchange exchange, McpSchema.CallToolRequest request) {
            return this.delegateCallToolResult.apply(exchange, request).map(result -> {
                if (this.outputSchema == null) {
                    if (result.getStructuredContent() != null) {
                        logger.warn("Tool call with no outputSchema is not expected to have a result with structured content, but got: {}", result.getStructuredContent());
                    }
                    return result;
                }
                if (result.getStructuredContent() == null) {
                    logger.warn("Response missing structured content which is expected when calling tool with non-empty outputSchema");
                    return new McpSchema.CallToolResult("Response missing structured content which is expected when calling tool with non-empty outputSchema", (Boolean)true);
                }
                JsonSchemaValidator.ValidationResponse validation = this.jsonSchemaValidator.validate(this.outputSchema, result.getStructuredContent());
                if (!validation.isValid()) {
                    logger.warn("Tool call result validation failed: {}", (Object)validation.getErrorMessage());
                    return new McpSchema.CallToolResult(validation.getErrorMessage(), (Boolean)true);
                }
                if (Utils.isEmpty(result.getContent())) {
                    return new McpSchema.CallToolResult(Utils.asList(new McpSchema.TextContent(validation.getJsonStructuredOutput())), result.getIsError(), result.getStructuredContent());
                }
                return result;
            });
        }
    }
}

