/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.DefaultMcpStatelessServerHandler;
import io.modelcontextprotocol.server.McpStatelessRequestHandler;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.spec.JsonSchemaValidator;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.DeafaultMcpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.McpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.Utils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class McpStatelessAsyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpStatelessAsyncServer.class);
    private final McpStatelessServerTransport mcpTransportProvider;
    private final ObjectMapper objectMapper;
    private final McpSchema.ServerCapabilities serverCapabilities;
    private final McpSchema.Implementation serverInfo;
    private final String instructions;
    private final CopyOnWriteArrayList<McpStatelessServerFeatures.AsyncToolSpecification> tools = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.AsyncResourceSpecification> resources = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.AsyncPromptSpecification> prompts = new ConcurrentHashMap();
    private final ConcurrentHashMap<McpSchema.CompleteReference, McpStatelessServerFeatures.AsyncCompletionSpecification> completions = new ConcurrentHashMap();
    private List<String> protocolVersions;
    private McpUriTemplateManagerFactory uriTemplateManagerFactory = new DeafaultMcpUriTemplateManagerFactory();
    private final JsonSchemaValidator jsonSchemaValidator;

    McpStatelessAsyncServer(McpStatelessServerTransport mcpTransport, ObjectMapper objectMapper, McpStatelessServerFeatures.Async features, Duration requestTimeout, McpUriTemplateManagerFactory uriTemplateManagerFactory, JsonSchemaValidator jsonSchemaValidator) {
        this.mcpTransportProvider = mcpTransport;
        this.objectMapper = objectMapper;
        this.serverInfo = features.getServerInfo();
        this.serverCapabilities = features.getServerCapabilities();
        this.instructions = features.getInstructions();
        this.tools.addAll(McpStatelessAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, features.getTools()));
        this.resources.putAll(features.getResources());
        this.resourceTemplates.addAll(features.getResourceTemplates());
        this.prompts.putAll(features.getPrompts());
        this.completions.putAll(features.getCompletions());
        this.uriTemplateManagerFactory = uriTemplateManagerFactory;
        this.jsonSchemaValidator = jsonSchemaValidator;
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("ping", (ctx, params) -> Mono.just((Object)Utils.asMap(new Object[0])));
        requestHandlers.put("initialize", this.asyncInitializeRequestHandler());
        if (this.serverCapabilities.getTools() != null) {
            requestHandlers.put("tools/list", this.toolsListRequestHandler());
            requestHandlers.put("tools/call", this.toolsCallRequestHandler());
        }
        if (this.serverCapabilities.getResources() != null) {
            requestHandlers.put("resources/list", this.resourcesListRequestHandler());
            requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
            requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
        }
        if (this.serverCapabilities.getPrompts() != null) {
            requestHandlers.put("prompts/list", this.promptsListRequestHandler());
            requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
        }
        if (this.serverCapabilities.getCompletions() != null) {
            requestHandlers.put("completion/complete", this.completionCompleteRequestHandler());
        }
        this.protocolVersions = new ArrayList<String>(mcpTransport.protocolVersions());
        DefaultMcpStatelessServerHandler handler = new DefaultMcpStatelessServerHandler(requestHandlers, Utils.asMap(new Object[0]));
        mcpTransport.setMcpHandler(handler);
    }

    private McpStatelessRequestHandler<McpSchema.InitializeResult> asyncInitializeRequestHandler() {
        return (ctx, req) -> Mono.defer(() -> {
            McpSchema.InitializeRequest initializeRequest = (McpSchema.InitializeRequest)this.objectMapper.convertValue(req, McpSchema.InitializeRequest.class);
            logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.getProtocolVersion(), initializeRequest.getCapabilities(), initializeRequest.getClientInfo()});
            String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
            if (this.protocolVersions.contains(initializeRequest.getProtocolVersion())) {
                serverProtocolVersion = initializeRequest.getProtocolVersion();
            } else {
                logger.warn("Client requested unsupported protocol version: {}, so the server will suggest the {} version instead", (Object)initializeRequest.getProtocolVersion(), (Object)serverProtocolVersion);
            }
            return Mono.just((Object)new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, this.instructions));
        });
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.serverCapabilities;
    }

    public McpSchema.Implementation getServerInfo() {
        return this.serverInfo;
    }

    public Mono<Void> closeGracefully() {
        return this.mcpTransportProvider.closeGracefully();
    }

    public void close() {
        this.mcpTransportProvider.close();
    }

    private static List<McpStatelessServerFeatures.AsyncToolSpecification> withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, List<McpStatelessServerFeatures.AsyncToolSpecification> tools) {
        if (Utils.isEmpty(tools)) {
            return tools;
        }
        return tools.stream().map(tool -> McpStatelessAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, tool)).collect(Collectors.toList());
    }

    private static McpStatelessServerFeatures.AsyncToolSpecification withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, McpStatelessServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification.getCallHandler() instanceof StructuredOutputCallToolHandler) {
            return toolSpecification;
        }
        if (toolSpecification.getTool().getOutputSchema() == null) {
            return toolSpecification;
        }
        return new McpStatelessServerFeatures.AsyncToolSpecification(toolSpecification.getTool(), new StructuredOutputCallToolHandler(jsonSchemaValidator, toolSpecification.getTool().getOutputSchema(), toolSpecification.getCallHandler()));
    }

    public Mono<Void> addTool(McpStatelessServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool specification must not be null"));
        }
        if (toolSpecification.getTool() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool must not be null"));
        }
        if (toolSpecification.getCallHandler() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool call handler must not be null"));
        }
        if (this.serverCapabilities.getTools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        McpStatelessServerFeatures.AsyncToolSpecification wrappedToolSpecification = McpStatelessAsyncServer.withStructuredOutputHandling(this.jsonSchemaValidator, toolSpecification);
        return Mono.defer(() -> {
            if (this.tools.stream().anyMatch(th -> th.getTool().getName().equals(wrappedToolSpecification.getTool().getName()))) {
                return Mono.error((Throwable)new McpError((Object)("Tool with name '" + wrappedToolSpecification.getTool().getName() + "' already exists")));
            }
            this.tools.add(wrappedToolSpecification);
            logger.debug("Added tool handler: {}", (Object)wrappedToolSpecification.getTool().getName());
            return Mono.empty();
        });
    }

    public Mono<Void> removeTool(String toolName) {
        if (toolName == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool name must not be null"));
        }
        if (this.serverCapabilities.getTools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        return Mono.defer(() -> {
            boolean removed = this.tools.removeIf(toolSpecification -> toolSpecification.getTool().getName().equals(toolName));
            if (removed) {
                logger.debug("Removed tool handler: {}", (Object)toolName);
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolName + "' not found")));
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Tool> tools = this.tools.stream().map(McpStatelessServerFeatures.AsyncToolSpecification::getTool).collect(Collectors.toList());
            return Mono.just((Object)new McpSchema.ListToolsResult(tools, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
        return (ctx, params) -> {
            McpSchema.CallToolRequest callToolRequest = (McpSchema.CallToolRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.CallToolRequest>(){});
            Optional<McpStatelessServerFeatures.AsyncToolSpecification> toolSpecification = this.tools.stream().filter(tr -> callToolRequest.getName().equals(tr.getTool().getName())).findAny();
            if (!toolSpecification.isPresent()) {
                return Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.getName())));
            }
            return toolSpecification.map(tool -> tool.getCallHandler().apply(ctx, callToolRequest)).orElse(Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.getName()))));
        };
    }

    public Mono<Void> addResource(McpStatelessServerFeatures.AsyncResourceSpecification resourceSpecification) {
        if (resourceSpecification == null || resourceSpecification.getResource() == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource must not be null"));
        }
        if (this.serverCapabilities.getResources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            if (this.resources.putIfAbsent(resourceSpecification.getResource().getUri(), resourceSpecification) != null) {
                return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceSpecification.getResource().getUri() + "' already exists")));
            }
            logger.debug("Added resource handler: {}", (Object)resourceSpecification.getResource().getUri());
            return Mono.empty();
        });
    }

    public Mono<Void> removeResource(String resourceUri) {
        if (resourceUri == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource URI must not be null"));
        }
        if (this.serverCapabilities.getResources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncResourceSpecification removed = this.resources.remove(resourceUri);
            if (removed != null) {
                logger.debug("Removed resource handler: {}", (Object)resourceUri);
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Resource> resourceList = this.resources.values().stream().map(McpStatelessServerFeatures.AsyncResourceSpecification::getResource).collect(Collectors.toList());
            return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
        return (ctx, params) -> Mono.just((Object)new McpSchema.ListResourceTemplatesResult(this.getResourceTemplates(), null));
    }

    private List<McpSchema.ResourceTemplate> getResourceTemplates() {
        ArrayList<McpSchema.ResourceTemplate> list = new ArrayList<McpSchema.ResourceTemplate>(this.resourceTemplates);
        List resourceTemplates = this.resources.keySet().stream().filter(uri -> uri.contains("{")).map(uri -> {
            McpSchema.Resource resource = this.resources.get(uri).getResource();
            McpSchema.ResourceTemplate template = new McpSchema.ResourceTemplate(resource.getUri(), resource.getName(), resource.getTitle(), resource.getDescription(), resource.getMimeType(), resource.getAnnotations());
            return template;
        }).collect(Collectors.toList());
        list.addAll(resourceTemplates);
        return list;
    }

    private McpStatelessRequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
        return (ctx, params) -> {
            McpSchema.ReadResourceRequest resourceRequest = (McpSchema.ReadResourceRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.ReadResourceRequest>(){});
            String resourceUri = resourceRequest.getUri();
            McpStatelessServerFeatures.AsyncResourceSpecification specification = this.resources.values().stream().filter(resourceSpecification -> this.uriTemplateManagerFactory.create(resourceSpecification.getResource().getUri()).matches(resourceUri)).findFirst().orElseThrow(() -> new McpError((Object)("Resource not found: " + resourceUri)));
            return specification.getReadHandler().apply(ctx, resourceRequest);
        };
    }

    public Mono<Void> addPrompt(McpStatelessServerFeatures.AsyncPromptSpecification promptSpecification) {
        if (promptSpecification == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt specification must not be null"));
        }
        if (this.serverCapabilities.getPrompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncPromptSpecification specification = this.prompts.putIfAbsent(promptSpecification.getPrompt().getName(), promptSpecification);
            if (specification != null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptSpecification.getPrompt().getName() + "' already exists")));
            }
            logger.debug("Added prompt handler: {}", (Object)promptSpecification.getPrompt().getName());
            return Mono.empty();
        });
    }

    public Mono<Void> removePrompt(String promptName) {
        if (promptName == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt name must not be null"));
        }
        if (this.serverCapabilities.getPrompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncPromptSpecification removed = this.prompts.remove(promptName);
            if (removed != null) {
                logger.debug("Removed prompt handler: {}", (Object)promptName);
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptName + "' not found")));
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Prompt> promptList = this.prompts.values().stream().map(McpStatelessServerFeatures.AsyncPromptSpecification::getPrompt).collect(Collectors.toList());
            return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
        return (ctx, params) -> {
            McpSchema.GetPromptRequest promptRequest = (McpSchema.GetPromptRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.GetPromptRequest>(){});
            McpStatelessServerFeatures.AsyncPromptSpecification specification = this.prompts.get(promptRequest.getName());
            if (specification == null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptRequest.getName())));
            }
            return specification.getPromptHandler().apply(ctx, promptRequest);
        };
    }

    private McpStatelessRequestHandler<McpSchema.CompleteResult> completionCompleteRequestHandler() {
        return (ctx, params) -> {
            McpStatelessServerFeatures.AsyncCompletionSpecification specification;
            McpSchema.CompleteRequest request = this.parseCompletionParams(params);
            if (request.getRef() == null) {
                return Mono.error((Throwable)new McpError((Object)"ref must not be null"));
            }
            if (request.getRef().getType() == null) {
                return Mono.error((Throwable)new McpError((Object)"type must not be null"));
            }
            String type = request.getRef().getType();
            String argumentName = request.getArgument().getName();
            if (type.equals("ref/prompt") && request.getRef() instanceof McpSchema.PromptReference) {
                McpSchema.PromptReference promptReference = (McpSchema.PromptReference)request.getRef();
                McpStatelessServerFeatures.AsyncPromptSpecification promptSpec = this.prompts.get(promptReference.getName());
                if (promptSpec == null) {
                    return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptReference.getName())));
                }
                if (promptSpec.getPrompt().getArguments().stream().noneMatch(arg -> arg.getName().equals(argumentName))) {
                    return Mono.error((Throwable)new McpError((Object)("Argument not found: " + argumentName)));
                }
            }
            if (type.equals("ref/resource") && request.getRef() instanceof McpSchema.ResourceReference) {
                McpSchema.ResourceReference resourceReference = (McpSchema.ResourceReference)request.getRef();
                McpStatelessServerFeatures.AsyncResourceSpecification resourceSpec = this.resources.get(resourceReference.getUri());
                if (resourceSpec == null) {
                    return Mono.error((Throwable)new McpError((Object)("Resource not found: " + resourceReference.getUri())));
                }
                if (!this.uriTemplateManagerFactory.create(resourceSpec.getResource().getUri()).getVariableNames().contains(argumentName)) {
                    return Mono.error((Throwable)new McpError((Object)("Argument not found: " + argumentName)));
                }
            }
            if ((specification = this.completions.get(request.getRef())) == null) {
                return Mono.error((Throwable)new McpError((Object)("AsyncCompletionSpecification not found: " + request.getRef())));
            }
            return specification.getCompletionHandler().apply(ctx, request);
        };
    }

    private McpSchema.CompleteRequest parseCompletionParams(Object object) {
        McpSchema.CompleteReference ref;
        Map params = (Map)object;
        Map refMap = (Map)params.get("ref");
        Map argMap = (Map)params.get("argument");
        String refType = (String)refMap.get("type");
        if ("ref/prompt".equals(refType)) {
            ref = new McpSchema.PromptReference(refType, (String)refMap.get("name"), refMap.get("title") != null ? (String)refMap.get("title") : null);
        } else if ("ref/resource".equals(refType)) {
            ref = new McpSchema.ResourceReference(refType, (String)refMap.get("uri"));
        } else {
            throw new IllegalArgumentException("Invalid ref type: " + refType);
        }
        String argName = (String)argMap.get("name");
        String argValue = (String)argMap.get("value");
        McpSchema.CompleteRequest.CompleteArgument argument = new McpSchema.CompleteRequest.CompleteArgument(argName, argValue);
        return new McpSchema.CompleteRequest(ref, argument);
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    private static class StructuredOutputCallToolHandler
    implements BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> {
        private final BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateHandler;
        private final JsonSchemaValidator jsonSchemaValidator;
        private final Map<String, Object> outputSchema;

        public StructuredOutputCallToolHandler(JsonSchemaValidator jsonSchemaValidator, Map<String, Object> outputSchema, BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateHandler) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            Assert.notNull(delegateHandler, "Delegate call tool result handler must not be null");
            this.delegateHandler = delegateHandler;
            this.outputSchema = outputSchema;
            this.jsonSchemaValidator = jsonSchemaValidator;
        }

        @Override
        public Mono<McpSchema.CallToolResult> apply(McpTransportContext transportContext, McpSchema.CallToolRequest request) {
            return this.delegateHandler.apply(transportContext, request).map(result -> {
                if (this.outputSchema == null) {
                    if (result.getStructuredContent() != null) {
                        logger.warn("Tool call with no outputSchema is not expected to have a result with structured content, but got: {}", result.getStructuredContent());
                    }
                    return result;
                }
                if (result.getStructuredContent() == null) {
                    logger.warn("Response missing structured content which is expected when calling tool with non-empty outputSchema");
                    return new McpSchema.CallToolResult("Response missing structured content which is expected when calling tool with non-empty outputSchema", (Boolean)true);
                }
                JsonSchemaValidator.ValidationResponse validation = this.jsonSchemaValidator.validate(this.outputSchema, result.getStructuredContent());
                if (!validation.isValid()) {
                    logger.warn("Tool call result validation failed: {}", (Object)validation.getErrorMessage());
                    return new McpSchema.CallToolResult(validation.getErrorMessage(), (Boolean)true);
                }
                if (Utils.isEmpty(result.getContent())) {
                    return new McpSchema.CallToolResult(Utils.asList(new McpSchema.TextContent(validation.getJsonStructuredOutput())), result.getIsError(), result.getStructuredContent());
                }
                return result;
            });
        }
    }
}

