/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.DefaultMcpTransportContext;
import io.modelcontextprotocol.server.McpStatelessServerHandler;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.server.McpTransportContextExtractor;
import io.modelcontextprotocol.server.transport.IMcpHttpServerTransport;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.io.IOException;
import java.util.List;
import org.noear.solon.SolonApp;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class WebRxStatelessServerTransport
implements McpStatelessServerTransport,
IMcpHttpServerTransport {
    private static final Logger logger = LoggerFactory.getLogger(WebRxStatelessServerTransport.class);
    private final ObjectMapper objectMapper;
    private final String mcpEndpoint;
    private McpStatelessServerHandler mcpHandler;
    private McpTransportContextExtractor<Context> contextExtractor;
    private volatile boolean isClosing = false;

    private WebRxStatelessServerTransport(ObjectMapper objectMapper, String mcpEndpoint, McpTransportContextExtractor<Context> contextExtractor) {
        Assert.notNull(objectMapper, "objectMapper must not be null");
        Assert.notNull(mcpEndpoint, "mcpEndpoint must not be null");
        Assert.notNull(contextExtractor, "contextExtractor must not be null");
        this.objectMapper = objectMapper;
        this.mcpEndpoint = mcpEndpoint;
        this.contextExtractor = contextExtractor;
    }

    @Override
    public void toHttpHandler(SolonApp app) {
        if (app != null) {
            app.get(this.mcpEndpoint, this::handleGet);
            app.post(this.mcpEndpoint, this::handlePost);
        }
    }

    @Override
    public String getMcpEndpoint() {
        return this.mcpEndpoint;
    }

    @Override
    public List<String> protocolVersions() {
        return Utils.asList("2025-03-26");
    }

    @Override
    public void setMcpHandler(McpStatelessServerHandler mcpHandler) {
        this.mcpHandler = mcpHandler;
    }

    @Override
    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> {
            this.isClosing = true;
        });
    }

    private void handleGet(Context request) {
        request.status(405);
    }

    private void handlePost(Context request) throws Throwable {
        Entity entity = this.handlePostDo(request);
        if (entity.body() != null) {
            if (entity.body() instanceof McpError) {
                McpError mcpError = (McpError)entity.body();
                entity.body((Object)mcpError.getMessage());
            } else if (entity.body() instanceof McpSchema.JSONRPCResponse) {
                entity.body((Object)this.objectMapper.writeValueAsString(entity.body()));
            }
        }
        request.returnValue((Object)entity);
    }

    private Entity handlePostDo(Context request) {
        if (this.isClosing) {
            return new Entity().status(503).body((Object)"Server is shutting down");
        }
        McpTransportContext transportContext = this.contextExtractor.extract(request, new DefaultMcpTransportContext());
        String acceptHeaders = request.acceptNew();
        if (!acceptHeaders.contains("application/json") || !acceptHeaders.contains("text/event-stream")) {
            return new Entity().status(400);
        }
        try {
            String body = request.body();
            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage(this.objectMapper, body);
            if (message instanceof McpSchema.JSONRPCRequest) {
                McpSchema.JSONRPCRequest jsonrpcRequest = (McpSchema.JSONRPCRequest)message;
                try {
                    McpSchema.JSONRPCResponse jsonrpcResponse = (McpSchema.JSONRPCResponse)this.mcpHandler.handleRequest(transportContext, jsonrpcRequest).contextWrite(ctx -> ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)transportContext)).block();
                    return new Entity().contentType("application/json").body((Object)jsonrpcResponse);
                }
                catch (Exception e) {
                    logger.error("Failed to handle request: {}", (Object)e.getMessage());
                    return new Entity().status(500).body((Object)new McpError((Object)("Failed to handle request: " + e.getMessage())));
                }
            }
            if (message instanceof McpSchema.JSONRPCNotification) {
                McpSchema.JSONRPCNotification jsonrpcNotification = (McpSchema.JSONRPCNotification)message;
                try {
                    this.mcpHandler.handleNotification(transportContext, jsonrpcNotification).contextWrite(ctx -> ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)transportContext)).block();
                    return new Entity().status(202);
                }
                catch (Exception e) {
                    logger.error("Failed to handle notification: {}", (Object)e.getMessage());
                    return new Entity().status(500).body((Object)new McpError((Object)("Failed to handle notification: " + e.getMessage())));
                }
            }
            return new Entity().status(400).body((Object)new McpError((Object)"The server accepts either requests or notifications"));
        }
        catch (IOException | IllegalArgumentException e) {
            logger.error("Failed to deserialize message: {}", (Object)e.getMessage());
            return new Entity().status(400).body((Object)new McpError((Object)"Invalid message format"));
        }
        catch (Exception e) {
            logger.error("Unexpected error handling message: {}", (Object)e.getMessage());
            return new Entity().status(500).body((Object)new McpError((Object)("Unexpected error: " + e.getMessage())));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ObjectMapper objectMapper;
        private String mcpEndpoint = "/mcp";
        private McpTransportContextExtractor<Context> contextExtractor = (serverRequest, context) -> {
            context.put(Context.class.getName(), serverRequest);
            return context;
        };

        private Builder() {
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder messageEndpoint(String messageEndpoint) {
            Assert.notNull(messageEndpoint, "Message endpoint must not be null");
            this.mcpEndpoint = messageEndpoint;
            return this;
        }

        public Builder contextExtractor(McpTransportContextExtractor<Context> contextExtractor) {
            Assert.notNull(contextExtractor, "Context extractor must not be null");
            this.contextExtractor = contextExtractor;
            return this;
        }

        public WebRxStatelessServerTransport build() {
            Assert.notNull(this.objectMapper, "ObjectMapper must be set");
            Assert.notNull(this.mcpEndpoint, "Message endpoint must be set");
            return new WebRxStatelessServerTransport(this.objectMapper, this.mcpEndpoint, this.contextExtractor);
        }
    }
}

