/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.ReflectionUtil;
import org.noear.solon.expression.snel.SafeNavigationNode;

public class MethodNode
implements Expression {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();
    private final Expression target;
    private final String methodName;
    private final List<Expression> args;
    private boolean safe = false;
    private static final ReflectionUtil methodUtil;
    private Method methodCached;

    public MethodNode(SafeNavigationNode target, List<Expression> args) {
        this(target.getTarget(), target.getPropertyName(), args);
        this.safe = true;
    }

    public MethodNode(Expression target, String methodName, List<Expression> args) {
        this.target = target;
        this.methodName = methodName;
        this.args = args;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public Object eval(Function context) {
        Object targetValue = this.target.eval(context);
        if (targetValue == null) {
            return null;
        }
        Object[] argValues = new Object[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            argValues[i] = this.args.get(i).eval(context);
        }
        try {
            Class<?> targetClass = targetValue instanceof Class ? (Class<?>)targetValue : targetValue.getClass();
            Class[] argTypes = new Class[argValues.length];
            for (int i = 0; i < argValues.length; ++i) {
                argTypes[i] = this.getEffectiveClass(argValues[i]);
            }
            Method method = methodUtil.getMethod(targetClass, this.methodName, argTypes);
            if (method == null) {
                throw new EvaluationException("Method not found: " + this.methodName);
            }
            Object[] invokeArgs = methodUtil.prepareInvokeArgs(method, argValues);
            if (targetValue instanceof Class) {
                return method.invoke(null, invokeArgs);
            }
            return method.invoke(targetValue, invokeArgs);
        }
        catch (Throwable e) {
            throw new EvaluationException("Failed to invoke method: " + this.methodName, e);
        }
    }

    private Class<?> getEffectiveClass(Object obj) {
        if (obj == null) {
            return Void.class;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isPrimitive()) {
            return PRIMITIVE_WRAPPER_MAP.get(clazz);
        }
        return clazz;
    }

    private Method findMethod(Class<?> clazz, String methodName, Object[] argValues) {
        if (this.methodCached == null) {
            Class[] argTypes = new Class[argValues.length];
            for (int i = 0; i < argValues.length; ++i) {
                argTypes[i] = this.getEffectiveClass(argValues[i]);
            }
            this.methodCached = methodUtil.getMethod(clazz, methodName, argTypes);
        }
        return this.methodCached;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.target);
        if (this.safe) {
            buf.append("?");
        }
        buf.append(".");
        buf.append(this.methodName);
        buf.append("(");
        for (Expression arg1 : this.args) {
            buf.append(arg1).append(",");
        }
        if (this.args.size() > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append(")");
        return buf.toString();
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        methodUtil = new ReflectionUtil();
    }
}

